/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.hooks.jei;

import java.util.ArrayList;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.JEIPlugin;
import mezz.jei.api.ingredients.IIngredientBlacklist;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeCategoryRegistration;
import mezz.jei.api.recipe.IRecipeWrapperFactory;
import mezz.jei.api.recipe.transfer.IRecipeTransferInfo;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.tslat.aoa3.advent.AdventOfAscension;
import net.tslat.aoa3.common.registration.BlockRegister;
import net.tslat.aoa3.common.registration.ItemRegister;
import net.tslat.aoa3.common.registration.WeaponRegister;
import net.tslat.aoa3.crafting.recipes.InfusionTableRecipe;
import net.tslat.aoa3.crafting.recipes.UpgradeKitRecipe;
import net.tslat.aoa3.hooks.ThirdPartyInteractions;
import net.tslat.aoa3.hooks.jei.recipecategory.FrameRecipeCategory;
import net.tslat.aoa3.hooks.jei.recipecategory.ImbuingRecipeCategory;
import net.tslat.aoa3.hooks.jei.recipecategory.InfusionRecipeCategory;
import net.tslat.aoa3.hooks.jei.recipecategory.UpgradeRecipeCategory;
import net.tslat.aoa3.hooks.jei.recipecategory.WhitewashingRecipeCategory;
import net.tslat.aoa3.hooks.jei.recipetransfer.InfusionTableRecipeTransferInfo;
import net.tslat.aoa3.hooks.jei.recipetransfer.UpgradeKitRecipeTransferInfo;
import net.tslat.aoa3.hooks.jei.recipetransfer.WhitewashingTableRecipeTransferInfo;
import net.tslat.aoa3.hooks.jei.recipewrapper.FrameRecipeWrapper;
import net.tslat.aoa3.hooks.jei.recipewrapper.InfusionRecipeWrapper;
import net.tslat.aoa3.hooks.jei.recipewrapper.UpgradeRecipeWrapper;
import net.tslat.aoa3.hooks.jei.recipewrapper.WhitewashingRecipeWrapper;

@JEIPlugin
public class JeiHooks
implements IModPlugin {
    public void register(IModRegistry registry) {
        if (!ThirdPartyInteractions.isJEIActive()) {
            return;
        }
        AdventOfAscension.logOptionalMessage("Beginning JEI Integration");
        this.registerHiddenItems(registry);
        registry.handleRecipes(InfusionTableRecipe.class, (IRecipeWrapperFactory)new InfusionRecipeWrapper.Factory(), "aoa3.infusion");
        registry.handleRecipes(InfusionTableRecipe.class, (IRecipeWrapperFactory)new InfusionRecipeWrapper.Factory(), "aoa3.imbuing");
        registry.handleRecipes(UpgradeKitRecipe.class, (IRecipeWrapperFactory)new UpgradeRecipeWrapper.Factory(), "aoa3.upgradeKits");
        registry.addRecipeCatalyst((Object)new ItemStack((Block)BlockRegister.INFUSION_TABLE), new String[]{"aoa3.infusion"});
        registry.addRecipeCatalyst((Object)new ItemStack((Block)BlockRegister.INFUSION_TABLE), new String[]{"aoa3.imbuing"});
        registry.addRecipeCatalyst((Object)new ItemStack((Block)BlockRegister.FRAME_BENCH), new String[]{"aoa3.frameBench"});
        registry.addRecipeCatalyst((Object)new ItemStack((Block)BlockRegister.WHITEWASHING_TABLE), new String[]{"aoa3.whitewashing"});
        registry.addRecipeCatalyst((Object)new ItemStack((Block)BlockRegister.DIVINE_STATION), new String[]{"aoa3.upgradeKits"});
        registry.addRecipes(this.compileFrameBenchRecipes(), "aoa3.frameBench");
        registry.addRecipes(this.compileWhitewashingRecipes(), "aoa3.whitewashing");
        registry.addRecipes(this.compileUpgradeKitRecipes(), "aoa3.upgradeKits");
        registry.getRecipeTransferRegistry().addRecipeTransferHandler((IRecipeTransferInfo)new InfusionTableRecipeTransferInfo("infusion"));
        registry.getRecipeTransferRegistry().addRecipeTransferHandler((IRecipeTransferInfo)new InfusionTableRecipeTransferInfo("imbuing"));
        registry.getRecipeTransferRegistry().addRecipeTransferHandler((IRecipeTransferInfo)new UpgradeKitRecipeTransferInfo());
        registry.getRecipeTransferRegistry().addRecipeTransferHandler((IRecipeTransferInfo)new WhitewashingTableRecipeTransferInfo());
        this.compileInfusionRecipes(registry);
    }

    public void registerCategories(IRecipeCategoryRegistration registry) {
        if (!ThirdPartyInteractions.isJEIActive()) {
            return;
        }
        registry.addRecipeCategories(new IRecipeCategory[]{new InfusionRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
        registry.addRecipeCategories(new IRecipeCategory[]{new ImbuingRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
        registry.addRecipeCategories(new IRecipeCategory[]{new FrameRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
        registry.addRecipeCategories(new IRecipeCategory[]{new WhitewashingRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
        registry.addRecipeCategories(new IRecipeCategory[]{new UpgradeRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
    }

    private void registerHiddenItems(IModRegistry registry) {
        IIngredientBlacklist blacklist = registry.getJeiHelpers().getIngredientBlacklist();
        blacklist.addIngredientToBlacklist((Object)new ItemStack((Block)BlockRegister.AMETHYST_LAMP));
        blacklist.addIngredientToBlacklist((Object)new ItemStack((Block)BlockRegister.AQUATIC_LAMP));
        blacklist.addIngredientToBlacklist((Object)new ItemStack((Block)BlockRegister.AQUA_LIFE_LAMP));
        blacklist.addIngredientToBlacklist((Object)new ItemStack((Block)BlockRegister.BARONYTE_LAMP));
        blacklist.addIngredientToBlacklist((Object)new ItemStack((Block)BlockRegister.BLACK_LIFE_LAMP));
        blacklist.addIngredientToBlacklist((Object)new ItemStack((Block)BlockRegister.BLAZIUM_LAMP));
        blacklist.addIngredientToBlacklist((Object)new ItemStack((Block)BlockRegister.BLOODSTONE_LAMP));
        blacklist.addIngredientToBlacklist((Object)new ItemStack((Block)BlockRegister.BLUE_LIFE_LAMP));
        blacklist.addIngredientToBlacklist((Object)new ItemStack((Block)BlockRegister.BROWN_LIFE_LAMP));
        blacklist.addIngredientToBlacklist((Object)new ItemStack((Block)BlockRegister.CRYSTALLITE_LAMP));
        blacklist.addIngredientToBlacklist((Object)new ItemStack((Block)BlockRegister.CYAN_LIFE_LAMP));
        blacklist.addIngredientToBlacklist((Object)new ItemStack((Block)BlockRegister.DARK_GREY_LIFE_LAMP));
        blacklist.addIngredientToBlacklist((Object)new ItemStack((Block)BlockRegister.ELECANIUM_LAMP));
        blacklist.addIngredientToBlacklist((Object)new ItemStack((Block)BlockRegister.EMBERSTONE_LAMP));
        blacklist.addIngredientToBlacklist((Object)new ItemStack((Block)BlockRegister.FIRE_LAMP));
        blacklist.addIngredientToBlacklist((Object)new ItemStack((Block)BlockRegister.GHASTLY_LAMP));
        blacklist.addIngredientToBlacklist((Object)new ItemStack((Block)BlockRegister.GHOULISH_LAMP));
        blacklist.addIngredientToBlacklist((Object)new ItemStack((Block)BlockRegister.GREEN_LIFE_LAMP));
        blacklist.addIngredientToBlacklist((Object)new ItemStack((Block)BlockRegister.GREY_LIFE_LAMP));
        blacklist.addIngredientToBlacklist((Object)new ItemStack((Block)BlockRegister.IRO_LAMP));
        blacklist.addIngredientToBlacklist((Object)new ItemStack((Block)BlockRegister.IVORY_AMETHYST_LAMP));
        blacklist.addIngredientToBlacklist((Object)new ItemStack((Block)BlockRegister.IVORY_JADE_LAMP));
        blacklist.addIngredientToBlacklist((Object)new ItemStack((Block)BlockRegister.IVORY_LAMP));
        blacklist.addIngredientToBlacklist((Object)new ItemStack((Block)BlockRegister.IVORY_LIMONITE_LAMP));
        blacklist.addIngredientToBlacklist((Object)new ItemStack((Block)BlockRegister.IVORY_ROSITE_LAMP));
        blacklist.addIngredientToBlacklist((Object)new ItemStack((Block)BlockRegister.IVORY_SAPPHIRE_LAMP));
        blacklist.addIngredientToBlacklist((Object)new ItemStack((Block)BlockRegister.JADE_LAMP));
        blacklist.addIngredientToBlacklist((Object)new ItemStack((Block)BlockRegister.LIME_LIFE_LAMP));
        blacklist.addIngredientToBlacklist((Object)new ItemStack((Block)BlockRegister.LIMONITE_LAMP));
        blacklist.addIngredientToBlacklist((Object)new ItemStack((Block)BlockRegister.LUNAR_LAMP));
        blacklist.addIngredientToBlacklist((Object)new ItemStack((Block)BlockRegister.LYON_LAMP));
        blacklist.addIngredientToBlacklist((Object)new ItemStack((Block)BlockRegister.MAGENTA_LIFE_LAMP));
        blacklist.addIngredientToBlacklist((Object)new ItemStack((Block)BlockRegister.MYSTIC_LAMP));
        blacklist.addIngredientToBlacklist((Object)new ItemStack((Block)BlockRegister.NEON_CIRCLING_LAMP));
        blacklist.addIngredientToBlacklist((Object)new ItemStack((Block)BlockRegister.NEON_LAMP));
        blacklist.addIngredientToBlacklist((Object)new ItemStack((Block)BlockRegister.NEON_LAPIS_CIRCLING_LAMP));
        blacklist.addIngredientToBlacklist((Object)new ItemStack((Block)BlockRegister.NEON_LAPIS_LAMP));
        blacklist.addIngredientToBlacklist((Object)new ItemStack((Block)BlockRegister.NEON_LAPIS_TRIANGLES_LAMP));
        blacklist.addIngredientToBlacklist((Object)new ItemStack((Block)BlockRegister.NEON_RUNIC_LAMP));
        blacklist.addIngredientToBlacklist((Object)new ItemStack((Block)BlockRegister.NEON_TRIANGLES_LAMP));
        blacklist.addIngredientToBlacklist((Object)new ItemStack((Block)BlockRegister.ORANGE_LIFE_LAMP));
        blacklist.addIngredientToBlacklist((Object)new ItemStack((Block)BlockRegister.PINK_LIFE_LAMP));
        blacklist.addIngredientToBlacklist((Object)new ItemStack((Block)BlockRegister.PURPLE_LIFE_LAMP));
        blacklist.addIngredientToBlacklist((Object)new ItemStack((Block)BlockRegister.RED_LIFE_LAMP));
        blacklist.addIngredientToBlacklist((Object)new ItemStack((Block)BlockRegister.ROSITE_LAMP));
        blacklist.addIngredientToBlacklist((Object)new ItemStack((Block)BlockRegister.SAPPHIRE_LAMP));
        blacklist.addIngredientToBlacklist((Object)new ItemStack((Block)BlockRegister.SKELETAL_LAMP));
        blacklist.addIngredientToBlacklist((Object)new ItemStack((Block)BlockRegister.WHITE_LIFE_LAMP));
        blacklist.addIngredientToBlacklist((Object)new ItemStack((Block)BlockRegister.YELLOW_LIFE_LAMP));
        blacklist.addIngredientToBlacklist((Object)new ItemStack((Item)ItemRegister.ALIEN_ORB));
        blacklist.addIngredientToBlacklist((Object)new ItemStack((Item)ItemRegister.DARK_BONES));
        blacklist.addIngredientToBlacklist((Object)new ItemStack((Item)ItemRegister.FLESHY_BONES));
        blacklist.addIngredientToBlacklist((Object)new ItemStack((Item)ItemRegister.MILLENNIUM_UPGRADER));
        blacklist.addIngredientToBlacklist((Object)new ItemStack((Item)ItemRegister.MOLTEN_UPGRADER));
        blacklist.addIngredientToBlacklist((Object)new ItemStack((Item)ItemRegister.MOONSTONE));
        blacklist.addIngredientToBlacklist((Object)new ItemStack((Item)ItemRegister.OLD_BOOT));
        blacklist.addIngredientToBlacklist((Object)new ItemStack((Item)ItemRegister.ROCK_BONES));
        blacklist.addIngredientToBlacklist((Object)new ItemStack((Item)ItemRegister.SOULBONE));
        blacklist.addIngredientToBlacklist((Object)new ItemStack((Item)ItemRegister.YETI_FINGERNAILS));
        blacklist.addIngredientToBlacklist((Object)new ItemStack((Item)WeaponRegister.COLOUR_CANNON));
        blacklist.addIngredientToBlacklist((Object)new ItemStack((Item)WeaponRegister.EXPERIMENT_W801));
        blacklist.addIngredientToBlacklist((Object)new ItemStack((Item)WeaponRegister.SHOE_FLINGER));
    }

    private ArrayList<UpgradeKitRecipe> compileUpgradeKitRecipes() {
        ArrayList<UpgradeKitRecipe> upgradeKitRecipes = new ArrayList<UpgradeKitRecipe>();
        for (IRecipe recipe : ForgeRegistries.RECIPES.getValuesCollection()) {
            if (!(recipe instanceof UpgradeKitRecipe)) continue;
            upgradeKitRecipes.add((UpgradeKitRecipe)recipe);
        }
        return upgradeKitRecipes;
    }

    private void compileInfusionRecipes(IModRegistry registry) {
        ArrayList<InfusionTableRecipe> infusionRecipes = new ArrayList<InfusionTableRecipe>();
        ArrayList<InfusionTableRecipe> imbuingRecipes = new ArrayList<InfusionTableRecipe>();
        for (IRecipe recipe : ForgeRegistries.RECIPES.getValuesCollection()) {
            if (!(recipe instanceof InfusionTableRecipe)) continue;
            if (((InfusionTableRecipe)recipe).isEnchanting()) {
                imbuingRecipes.add((InfusionTableRecipe)recipe);
                continue;
            }
            infusionRecipes.add((InfusionTableRecipe)recipe);
        }
        registry.addRecipes(infusionRecipes, "aoa3.infusion");
        registry.addRecipes(imbuingRecipes, "aoa3.imbuing");
    }

    private ArrayList<FrameRecipeWrapper> compileFrameBenchRecipes() {
        ArrayList<FrameRecipeWrapper> frameRecipes = new ArrayList<FrameRecipeWrapper>(10);
        frameRecipes.add(new FrameRecipeWrapper(ItemRegister.ARCHERGUN_FRAME));
        frameRecipes.add(new FrameRecipeWrapper(ItemRegister.BLASTER_FRAME));
        frameRecipes.add(new FrameRecipeWrapper(ItemRegister.CANNON_FRAME));
        frameRecipes.add(new FrameRecipeWrapper(ItemRegister.HELMET_FRAME));
        frameRecipes.add(new FrameRecipeWrapper(ItemRegister.CHESTPLATE_FRAME));
        frameRecipes.add(new FrameRecipeWrapper(ItemRegister.LEGGINGS_FRAME));
        frameRecipes.add(new FrameRecipeWrapper(ItemRegister.BOOTS_FRAME));
        frameRecipes.add(new FrameRecipeWrapper(ItemRegister.GUN_FRAME));
        frameRecipes.add(new FrameRecipeWrapper(ItemRegister.SHOTGUN_FRAME));
        frameRecipes.add(new FrameRecipeWrapper(ItemRegister.SNIPER_FRAME));
        return frameRecipes;
    }

    private ArrayList<WhitewashingRecipeWrapper> compileWhitewashingRecipes() {
        ArrayList<WhitewashingRecipeWrapper> whitewashingRecipes = new ArrayList<WhitewashingRecipeWrapper>(2);
        whitewashingRecipes.add(new WhitewashingRecipeWrapper(BlockRegister.WHITEWASH_BRICKS));
        whitewashingRecipes.add(new WhitewashingRecipeWrapper(BlockRegister.DARKWASH_BRICKS));
        return whitewashingRecipes;
    }
}

