/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.hooks.jer;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import jeresources.api.IDungeonRegistry;
import jeresources.api.IJERAPI;
import jeresources.api.IMobRegistry;
import jeresources.api.IPlantRegistry;
import jeresources.api.IWorldGenRegistry;
import jeresources.api.JERPlugin;
import jeresources.api.conditionals.LightLevel;
import jeresources.api.distributions.DistributionBase;
import jeresources.api.distributions.DistributionSquare;
import jeresources.api.drop.LootDrop;
import jeresources.api.drop.PlantDrop;
import jeresources.api.restrictions.DimensionRestriction;
import jeresources.api.restrictions.Restriction;
import jeresources.util.LootTableHelper;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCrops;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.boss.EntityWither;
import net.minecraft.entity.monster.IMob;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootEntryItem;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.tslat.aoa3.advent.AdventOfAscension;
import net.tslat.aoa3.block.functional.crops.CropBlock;
import net.tslat.aoa3.common.registration.BlockRegister;
import net.tslat.aoa3.common.registration.DimensionRegister;
import net.tslat.aoa3.common.registration.EntitySpawnRegister;
import net.tslat.aoa3.common.registration.ItemRegister;
import net.tslat.aoa3.common.registration.LootSystemRegister;
import net.tslat.aoa3.utils.ConfigurationUtil;

public class JerHooks {
    @JERPlugin
    public static IJERAPI jerAPI = null;

    public static void init() {
        if (jerAPI == null) {
            return;
        }
        JerHooks.integrateMobDrops();
        JerHooks.integrateDungeonLoot();
        JerHooks.integrateCrops();
        JerHooks.integrateWorldGen();
    }

    private static void integrateWorldGen() {
        IWorldGenRegistry worldGenRegistry = jerAPI.getWorldGenRegistry();
        worldGenRegistry.register(new ItemStack((Block)BlockRegister.AMETHYST_ORE), (DistributionBase)new DistributionSquare(ConfigurationUtil.OreConfig.amethyst.maxVeinsPerChunk / 2, (ConfigurationUtil.OreConfig.amethyst.minOresPerVein + ConfigurationUtil.OreConfig.amethyst.maxOresPerVein) / 2, 14, 30), true, new LootDrop[]{new LootDrop(new ItemStack((Item)ItemRegister.AMETHYST))});
        worldGenRegistry.register(new ItemStack((Block)BlockRegister.JADE_ORE), (DistributionBase)new DistributionSquare(ConfigurationUtil.OreConfig.jade.maxVeinsPerChunk / 2, (ConfigurationUtil.OreConfig.jade.minOresPerVein + ConfigurationUtil.OreConfig.jade.maxOresPerVein) / 2, 7, 19), new LootDrop[0]);
        worldGenRegistry.register(new ItemStack((Block)BlockRegister.LIMONITE_ORE), (DistributionBase)new DistributionSquare(ConfigurationUtil.OreConfig.limonite.maxVeinsPerChunk / 2, (ConfigurationUtil.OreConfig.limonite.minOresPerVein + ConfigurationUtil.OreConfig.limonite.maxOresPerVein) / 2, 8, 67), new LootDrop[0]);
        worldGenRegistry.register(new ItemStack((Block)BlockRegister.ROSITE_ORE), (DistributionBase)new DistributionSquare(ConfigurationUtil.OreConfig.rosite.maxVeinsPerChunk / 2, (ConfigurationUtil.OreConfig.rosite.minOresPerVein + ConfigurationUtil.OreConfig.rosite.maxOresPerVein) / 2, 17, 47), new LootDrop[0]);
        worldGenRegistry.register(new ItemStack((Block)BlockRegister.RUNIUM_ORE), (DistributionBase)new DistributionSquare(ConfigurationUtil.OreConfig.runium.maxVeinsPerChunk / 2, (ConfigurationUtil.OreConfig.runium.minOresPerVein + ConfigurationUtil.OreConfig.runium.maxOresPerVein) / 2, 5, 132), new LootDrop[0]);
        worldGenRegistry.register(new ItemStack((Block)BlockRegister.SAPPHIRE_ORE), (DistributionBase)new DistributionSquare(ConfigurationUtil.OreConfig.sapphire.maxVeinsPerChunk / 2, (ConfigurationUtil.OreConfig.sapphire.minOresPerVein + ConfigurationUtil.OreConfig.sapphire.maxOresPerVein) / 2, 4, 11), true, new LootDrop[]{new LootDrop(new ItemStack((Item)ItemRegister.SAPPHIRE))});
        worldGenRegistry.register(new ItemStack((Block)BlockRegister.BLOODSTONE_ORE), (DistributionBase)new DistributionSquare(ConfigurationUtil.OreConfig.bloodstone.veinsPerChunk, (ConfigurationUtil.OreConfig.bloodstone.minOresPerVein + ConfigurationUtil.OreConfig.bloodstone.maxOresPerVein) / 2, 45, 49), new Restriction(new DimensionRestriction(DimensionRegister.DIM_ABYSS)), true, new LootDrop[]{new LootDrop(new ItemStack((Item)ItemRegister.BLOODSTONE))});
        worldGenRegistry.register(new ItemStack((Block)BlockRegister.BARONYTE_ORE), (DistributionBase)new DistributionSquare(ConfigurationUtil.OreConfig.baronyte.veinsPerChunk, (ConfigurationUtil.OreConfig.baronyte.minOresPerVein + ConfigurationUtil.OreConfig.baronyte.maxOresPerVein) / 2, 25, 34), new Restriction(new DimensionRestriction(DimensionRegister.DIM_BARATHOS)), new LootDrop[0]);
        worldGenRegistry.register(new ItemStack((Block)BlockRegister.BLAZIUM_ORE), (DistributionBase)new DistributionSquare(ConfigurationUtil.OreConfig.blazium.veinsPerChunk, (ConfigurationUtil.OreConfig.blazium.minOresPerVein + ConfigurationUtil.OreConfig.blazium.maxOresPerVein) / 2, 0, 19), new Restriction(new DimensionRestriction(DimensionRegister.DIM_BARATHOS)), new LootDrop[0]);
        worldGenRegistry.register(new ItemStack((Block)BlockRegister.VARSIUM_ORE), (DistributionBase)new DistributionSquare(ConfigurationUtil.OreConfig.varsium.veinsPerChunk, (ConfigurationUtil.OreConfig.varsium.minOresPerVein + ConfigurationUtil.OreConfig.varsium.maxOresPerVein) / 2, 25, 62), new Restriction(new DimensionRestriction(DimensionRegister.DIM_BARATHOS)), new LootDrop[0]);
        worldGenRegistry.register(new ItemStack((Block)BlockRegister.BLUE_CRYSTAL_ORE), (DistributionBase)new DistributionSquare(ConfigurationUtil.OreConfig.blueCrystal.veinsPerChunk, (ConfigurationUtil.OreConfig.blueCrystal.minOresPerVein + ConfigurationUtil.OreConfig.blueCrystal.maxOresPerVein) / 2, 10, 109), new Restriction(new DimensionRestriction(DimensionRegister.DIM_CRYSTEVIA)), new LootDrop[0]);
        worldGenRegistry.register(new ItemStack((Block)BlockRegister.GREEN_CRYSTAL_ORE), (DistributionBase)new DistributionSquare(ConfigurationUtil.OreConfig.greenCrystal.veinsPerChunk, (ConfigurationUtil.OreConfig.greenCrystal.minOresPerVein + ConfigurationUtil.OreConfig.greenCrystal.maxOresPerVein) / 2, 10, 109), new Restriction(new DimensionRestriction(DimensionRegister.DIM_CRYSTEVIA)), new LootDrop[0]);
        worldGenRegistry.register(new ItemStack((Block)BlockRegister.RED_CRYSTAL_ORE), (DistributionBase)new DistributionSquare(ConfigurationUtil.OreConfig.redCrystal.veinsPerChunk, (ConfigurationUtil.OreConfig.redCrystal.minOresPerVein + ConfigurationUtil.OreConfig.redCrystal.maxOresPerVein) / 2, 10, 109), new Restriction(new DimensionRestriction(DimensionRegister.DIM_CRYSTEVIA)), new LootDrop[0]);
        worldGenRegistry.register(new ItemStack((Block)BlockRegister.PURPLE_CRYSTAL_ORE), (DistributionBase)new DistributionSquare(ConfigurationUtil.OreConfig.purpleCrystal.veinsPerChunk, (ConfigurationUtil.OreConfig.purpleCrystal.minOresPerVein + ConfigurationUtil.OreConfig.purpleCrystal.maxOresPerVein) / 2, 10, 109), new Restriction(new DimensionRestriction(DimensionRegister.DIM_CRYSTEVIA)), new LootDrop[0]);
        worldGenRegistry.register(new ItemStack((Block)BlockRegister.WHITE_CRYSTAL_ORE), (DistributionBase)new DistributionSquare(ConfigurationUtil.OreConfig.whiteCrystal.veinsPerChunk, (ConfigurationUtil.OreConfig.whiteCrystal.minOresPerVein + ConfigurationUtil.OreConfig.whiteCrystal.maxOresPerVein) / 2, 10, 109), new Restriction(new DimensionRestriction(DimensionRegister.DIM_CRYSTEVIA)), new LootDrop[0]);
        worldGenRegistry.register(new ItemStack((Block)BlockRegister.YELLOW_CRYSTAL_ORE), (DistributionBase)new DistributionSquare(ConfigurationUtil.OreConfig.yellowCrystal.veinsPerChunk, (ConfigurationUtil.OreConfig.yellowCrystal.minOresPerVein + ConfigurationUtil.OreConfig.yellowCrystal.maxOresPerVein) / 2, 10, 109), new Restriction(new DimensionRestriction(DimensionRegister.DIM_CRYSTEVIA)), new LootDrop[0]);
        worldGenRegistry.register(new ItemStack((Block)BlockRegister.CHARGED_RUNIUM_ORE), (DistributionBase)new DistributionSquare(ConfigurationUtil.OreConfig.chargedRunium.veinsPerChunk, (ConfigurationUtil.OreConfig.chargedRunium.minOresPerVein + ConfigurationUtil.OreConfig.chargedRunium.maxOresPerVein) / 2, 70, 114), new Restriction(new DimensionRestriction(DimensionRegister.DIM_DEEPLANDS)), new LootDrop[0]);
        worldGenRegistry.register(new ItemStack((Block)BlockRegister.DEEP_CASE), (DistributionBase)new DistributionSquare(4, 5, 70, 114), new Restriction(new DimensionRestriction(DimensionRegister.DIM_DEEPLANDS)), new LootDrop[0]);
        worldGenRegistry.register(new ItemStack((Block)BlockRegister.CHESTBONE_FRAGMENTS_ORE), (DistributionBase)new DistributionSquare(ConfigurationUtil.OreConfig.chestboneFragments.veinsPerChunk, (ConfigurationUtil.OreConfig.chestboneFragments.minOresPerVein + ConfigurationUtil.OreConfig.chestboneFragments.maxOresPerVein) / 2, 0, 40), new Restriction(new DimensionRestriction(DimensionRegister.DIM_PRECASIA)), new LootDrop[0]);
        worldGenRegistry.register(new ItemStack((Block)BlockRegister.FOOTBONE_FRAGMENTS_ORE), (DistributionBase)new DistributionSquare(ConfigurationUtil.OreConfig.footboneFragments.veinsPerChunk, (ConfigurationUtil.OreConfig.footboneFragments.minOresPerVein + ConfigurationUtil.OreConfig.footboneFragments.maxOresPerVein) / 2, 0, 40), new Restriction(new DimensionRestriction(DimensionRegister.DIM_PRECASIA)), new LootDrop[0]);
        worldGenRegistry.register(new ItemStack((Block)BlockRegister.LEGBONE_FRAGMENTS_ORE), (DistributionBase)new DistributionSquare(ConfigurationUtil.OreConfig.legboneFragments.veinsPerChunk, (ConfigurationUtil.OreConfig.legboneFragments.minOresPerVein + ConfigurationUtil.OreConfig.legboneFragments.maxOresPerVein) / 2, 0, 40), new Restriction(new DimensionRestriction(DimensionRegister.DIM_PRECASIA)), new LootDrop[0]);
        worldGenRegistry.register(new ItemStack((Block)BlockRegister.SKULLBONE_FRAGMENTS_ORE), (DistributionBase)new DistributionSquare(ConfigurationUtil.OreConfig.skullboneFragments.veinsPerChunk, (ConfigurationUtil.OreConfig.skullboneFragments.minOresPerVein + ConfigurationUtil.OreConfig.skullboneFragments.maxOresPerVein) / 2, 0, 40), new Restriction(new DimensionRestriction(DimensionRegister.DIM_PRECASIA)), new LootDrop[0]);
        worldGenRegistry.register(new ItemStack((Block)BlockRegister.CRYSTALLITE_ORE), (DistributionBase)new DistributionSquare(ConfigurationUtil.OreConfig.crystallite.veinsPerChunk, (ConfigurationUtil.OreConfig.crystallite.minOresPerVein + ConfigurationUtil.OreConfig.crystallite.maxOresPerVein) / 2, 30, 69), new Restriction(new DimensionRestriction(DimensionRegister.DIM_HAVEN)), true, new LootDrop[]{new LootDrop(new ItemStack((Item)ItemRegister.CRYSTALLITE))});
        worldGenRegistry.register(new ItemStack((Block)BlockRegister.ELECANIUM_ORE), (DistributionBase)new DistributionSquare(ConfigurationUtil.OreConfig.elecanium.veinsPerChunk, (ConfigurationUtil.OreConfig.elecanium.minOresPerVein + ConfigurationUtil.OreConfig.elecanium.maxOresPerVein) / 2, 1, 35), new Restriction(new DimensionRestriction(DimensionRegister.DIM_RUNANDOR)), new LootDrop[0]);
        worldGenRegistry.register(new ItemStack((Block)BlockRegister.EMBERSTONE_ORE), (DistributionBase)new DistributionSquare(ConfigurationUtil.OreConfig.emberstone.veinsPerChunk, (ConfigurationUtil.OreConfig.emberstone.minOresPerVein + ConfigurationUtil.OreConfig.emberstone.maxOresPerVein) / 2, 5, 124), new Restriction(new DimensionRestriction(-1)), new LootDrop[0]);
        worldGenRegistry.register(new ItemStack((Block)BlockRegister.GEMENYTE_ORE), (DistributionBase)new DistributionSquare(ConfigurationUtil.OreConfig.gemenyte.veinsPerChunk, (ConfigurationUtil.OreConfig.gemenyte.minOresPerVein + ConfigurationUtil.OreConfig.gemenyte.maxOresPerVein) / 2, 22, 36), new Restriction(new DimensionRestriction(DimensionRegister.DIM_CREEPONIA)), true, new LootDrop[]{new LootDrop(new ItemStack((Item)ItemRegister.GEMENYTE))});
        worldGenRegistry.register(new ItemStack((Block)BlockRegister.JEWELYTE_ORE), (DistributionBase)new DistributionSquare(ConfigurationUtil.OreConfig.jewelyte.veinsPerChunk, (ConfigurationUtil.OreConfig.jewelyte.minOresPerVein + ConfigurationUtil.OreConfig.jewelyte.maxOresPerVein) / 2, 22, 36), new Restriction(new DimensionRestriction(DimensionRegister.DIM_CREEPONIA)), true, new LootDrop[]{new LootDrop(new ItemStack((Item)ItemRegister.JEWELYTE))});
        worldGenRegistry.register(new ItemStack((Block)BlockRegister.ORNAMYTE_ORE), (DistributionBase)new DistributionSquare(ConfigurationUtil.OreConfig.ornamyte.veinsPerChunk, (ConfigurationUtil.OreConfig.ornamyte.minOresPerVein + ConfigurationUtil.OreConfig.ornamyte.maxOresPerVein) / 2, 3, 14), new Restriction(new DimensionRestriction(DimensionRegister.DIM_CREEPONIA)), true, new LootDrop[]{new LootDrop(new ItemStack((Item)ItemRegister.ORNAMYTE))});
        worldGenRegistry.register(new ItemStack((Block)BlockRegister.GHASTLY_ORE), (DistributionBase)new DistributionSquare(ConfigurationUtil.OreConfig.ghastly.veinsPerChunk, (ConfigurationUtil.OreConfig.ghastly.minOresPerVein + ConfigurationUtil.OreConfig.ghastly.maxOresPerVein) / 2, 3, 27), new Restriction(new DimensionRestriction(DimensionRegister.DIM_GRECKON)), new LootDrop[0]);
        worldGenRegistry.register(new ItemStack((Block)BlockRegister.GHOULISH_ORE), (DistributionBase)new DistributionSquare(ConfigurationUtil.OreConfig.ghoulish.veinsPerChunk, (ConfigurationUtil.OreConfig.ghoulish.minOresPerVein + ConfigurationUtil.OreConfig.ghoulish.maxOresPerVein) / 2, 30, 59), new Restriction(new DimensionRestriction(DimensionRegister.DIM_GRECKON)), new LootDrop[0]);
        worldGenRegistry.register(new ItemStack((Block)BlockRegister.LYON_ORE), (DistributionBase)new DistributionSquare(ConfigurationUtil.OreConfig.lyon.veinsPerChunk, (ConfigurationUtil.OreConfig.lyon.minOresPerVein + ConfigurationUtil.OreConfig.lyon.maxOresPerVein) / 2, 45, 64), new Restriction(new DimensionRestriction(DimensionRegister.DIM_IROMINE)), new LootDrop[0]);
        worldGenRegistry.register(new ItemStack((Block)BlockRegister.MYSTITE_ORE), (DistributionBase)new DistributionSquare(ConfigurationUtil.OreConfig.mystite.veinsPerChunk, (ConfigurationUtil.OreConfig.mystite.minOresPerVein + ConfigurationUtil.OreConfig.mystite.maxOresPerVein) / 2, 2, 21), new Restriction(new DimensionRestriction(DimensionRegister.DIM_MYSTERIUM)), new LootDrop[0]);
        worldGenRegistry.register(new ItemStack((Block)BlockRegister.SHYREGEM_ORE), (DistributionBase)new DistributionSquare((int)Math.ceil((float)(ConfigurationUtil.OreConfig.shyre.minBlocksPerChunk + ConfigurationUtil.OreConfig.shyre.maxBlocksPerChunk) / 2.0f * 0.125f), 1, 2, 26), new Restriction(new DimensionRestriction(DimensionRegister.DIM_SHYRELANDS)), true, new LootDrop[]{new LootDrop(new ItemStack((Item)ItemRegister.SHYREGEM))});
        worldGenRegistry.register(new ItemStack((Block)BlockRegister.SHYRESTONE_ORE), (DistributionBase)new DistributionSquare((int)Math.ceil((float)(ConfigurationUtil.OreConfig.shyre.minBlocksPerChunk + ConfigurationUtil.OreConfig.shyre.maxBlocksPerChunk) / 2.0f * 0.875f), 1, 2, 26), new Restriction(new DimensionRestriction(DimensionRegister.DIM_SHYRELANDS)), new LootDrop[0]);
    }

    private static void integrateCrops() {
        IPlantRegistry plantRegistry = jerAPI.getPlantRegistry();
        try {
            Method getSeedsMethod = ObfuscationReflectionHelper.findMethod(BlockCrops.class, (String)"func_149866_i", Item.class, (Class[])new Class[0]);
            for (Block block : ForgeRegistries.BLOCKS.getValuesCollection()) {
                if (!(block instanceof CropBlock)) continue;
                CropBlock crop = (CropBlock)block;
                Item seedItem = (Item)getSeedsMethod.invoke((Object)crop, new Object[0]);
                ItemStack seeds = new ItemStack(seedItem);
                if (crop.dropsSeeds()) {
                    plantRegistry.register(seeds, (IPlantable)seedItem, new PlantDrop[]{new PlantDrop(new ItemStack(crop.func_149865_P()), 1.0f), new PlantDrop(seeds, 0, 3)});
                    continue;
                }
                plantRegistry.register(seeds, (IPlantable)seedItem, new PlantDrop[]{new PlantDrop(new ItemStack(crop.func_149865_P()), 1.0f), new PlantDrop(seeds, 0, 1)});
            }
        }
        catch (Exception ex) {
            AdventOfAscension.logOptionalMessage("Error while reflecting crop blocks for JER, skipping.", ex);
        }
    }

    private static void integrateDungeonLoot() {
        IDungeonRegistry dungeonRegistry = jerAPI.getDungeonRegistry();
        dungeonRegistry.registerChest("Aquatic Castle", LootSystemRegister.structureAquaticCastle);
        dungeonRegistry.registerChest("Baron Castle", LootSystemRegister.structureBaronCastle);
        dungeonRegistry.registerChest("Dawnlight Dungeon", LootSystemRegister.structureDawnlightDungeon);
        dungeonRegistry.registerChest("Floro Castle", LootSystemRegister.structureFloroCastle);
        dungeonRegistry.registerChest("Garden Castle", LootSystemRegister.structureGardenCastle);
        dungeonRegistry.registerChest("Gingerbread House", LootSystemRegister.structureGingerbreadHouse);
        dungeonRegistry.registerChest("Guardian Tower", LootSystemRegister.structureGuardianTowerChests);
        dungeonRegistry.registerChest("Haunted Castle", LootSystemRegister.structureHauntedCastleTopChest);
        dungeonRegistry.registerChest("Iro Passages", LootSystemRegister.structureIroPassageChests);
        dungeonRegistry.registerChest("Lelyetian Tower", LootSystemRegister.structureLelyetianTower);
        dungeonRegistry.registerChest("Lunar Food Market", LootSystemRegister.structureLunarFoodMarket);
        dungeonRegistry.registerChest("Lunarade Stand", LootSystemRegister.structureLunaradeStand);
        dungeonRegistry.registerChest("Spellbinder House", LootSystemRegister.structureSpellbinderHouse);
    }

    private static void integrateMobDrops() {
        Field experienceField;
        Field conditionsField;
        Method getLootTableMethod;
        World fakeClientWorld = jerAPI.getWorld();
        IMobRegistry mobRegistry = jerAPI.getMobRegistry();
        HashSet<EntitySpawnRegister.SpawnEntry> spawnEntries = new HashSet<EntitySpawnRegister.SpawnEntry>();
        spawnEntries.addAll(EntitySpawnRegister.getOverworldSpawns(true));
        spawnEntries.addAll(EntitySpawnRegister.getNetherSpawns());
        spawnEntries.addAll(EntitySpawnRegister.getDimensionSpawns());
        try {
            getLootTableMethod = ObfuscationReflectionHelper.findMethod(EntityLiving.class, (String)"func_184647_J", ResourceLocation.class, (Class[])new Class[0]);
            conditionsField = ObfuscationReflectionHelper.findField(LootEntry.class, (String)"field_186366_e");
            experienceField = ObfuscationReflectionHelper.findField(EntityLiving.class, (String)"field_70728_aV");
        }
        catch (ReflectionHelper.UnableToFindMethodException ex) {
            AdventOfAscension.logOptionalMessage("Unable to reflect EntityLiving class, dropping JER support.", (Exception)((Object)ex));
            return;
        }
        mobRegistry.register((EntityLivingBase)new EntityWither(fakeClientWorld), LootSystemRegister.entityWither);
        for (EntityEntry entry : ForgeRegistries.ENTITIES.getValuesCollection()) {
            if (!entry.getRegistryName().func_110624_b().equals("aoa3") || !EntityLivingBase.class.isAssignableFrom(entry.getEntityClass())) continue;
            EntityLivingBase entity = (EntityLivingBase)entry.newInstance(fakeClientWorld);
            LightLevel lightReq = entity instanceof IMob ? LightLevel.hostile : LightLevel.any;
            int xp = 0;
            if (getLootTableMethod == null) continue;
            try {
                ResourceLocation lootTable = (ResourceLocation)getLootTableMethod.invoke((Object)entity, new Object[0]);
                if (lootTable == null) continue;
                if (entity instanceof EntityLiving) {
                    xp = (Integer)experienceField.get(entity);
                }
                ArrayList<LootDrop> drops = new ArrayList<LootDrop>();
                LootTable table = LootTableHelper.getManager((World)fakeClientWorld).func_186521_a(lootTable);
                for (LootPool pool : LootTableHelper.getPools((LootTable)table)) {
                    ArrayList<LootEntryItem> entries = new ArrayList<LootEntryItem>();
                    float totalWeight = 0.0f;
                    List poolConditions = LootTableHelper.getConditions((LootPool)pool);
                    for (LootEntry lootEntry : LootTableHelper.getEntries((LootPool)pool)) {
                        if (!(lootEntry instanceof LootEntryItem)) continue;
                        totalWeight += (float)lootEntry.func_186361_a(0.0f);
                        entries.add((LootEntryItem)lootEntry);
                    }
                    for (LootEntryItem lootEntryItem : entries) {
                        LootDrop drop = new LootDrop(LootTableHelper.getItem((LootEntryItem)lootEntryItem), (float)lootEntryItem.func_186361_a(0.0f) / totalWeight, (LootCondition[])conditionsField.get(lootEntryItem), LootTableHelper.getFunctions((LootEntryItem)lootEntryItem));
                        drop.addLootConditions((Collection)poolConditions);
                        drops.add(drop);
                    }
                }
                EntitySpawnRegister.SpawnEntry foundSpawnEntry = null;
                Iterator spawnEntryIterator = spawnEntries.iterator();
                while (spawnEntryIterator.hasNext()) {
                    EntitySpawnRegister.SpawnEntry spawnEntry = (EntitySpawnRegister.SpawnEntry)spawnEntryIterator.next();
                    if (!spawnEntry.entityClass.equals(entity.getClass())) continue;
                    foundSpawnEntry = spawnEntry;
                    spawnEntryIterator.remove();
                    break;
                }
                if (foundSpawnEntry == null) {
                    mobRegistry.register(entity, lightReq, xp, new String[]{"No Natural Spawns"}, drops.toArray(new LootDrop[0]));
                    continue;
                }
                String[] biomes = new String[foundSpawnEntry.biomes.length];
                for (int i = 0; i < foundSpawnEntry.biomes.length; ++i) {
                    biomes[i] = foundSpawnEntry.biomes[i].func_185359_l();
                }
                mobRegistry.register(entity, lightReq, xp, biomes, drops.toArray(new LootDrop[0]));
            }
            catch (Exception ex) {
                AdventOfAscension.logOptionalMessage("Unable to reflect method or field from EntityLiving class.", ex);
            }
        }
    }
}

