/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.hooks.tconstruct;

import net.minecraft.block.Block;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.tslat.aoa3.block.BasicFluidBlock;
import net.tslat.aoa3.hooks.tconstruct.TinkersFluidRegistry;
import net.tslat.aoa3.hooks.tconstruct.traits.Traits;
import net.tslat.aoa3.utils.ConfigurationUtil;
import slimeknights.tconstruct.common.ModelRegisterUtil;
import slimeknights.tconstruct.library.modifiers.IModifier;

public class TinkerClientEventHandler {
    @SubscribeEvent
    public void modelRegistration(ModelRegistryEvent ev) {
        TinkerClientEventHandler.registerFluidModels(new Fluid[]{TinkersFluidRegistry.BARONYTE, TinkersFluidRegistry.BLAZIUM, TinkersFluidRegistry.CHARGER, TinkersFluidRegistry.ELECANIUM, TinkersFluidRegistry.EMBERSTONE, TinkersFluidRegistry.GHASTLY, TinkersFluidRegistry.GHOULISH, TinkersFluidRegistry.LIMONITE, TinkersFluidRegistry.LUNAR, TinkersFluidRegistry.LYON, TinkersFluidRegistry.MYSTITE, TinkersFluidRegistry.ROSITE, TinkersFluidRegistry.SHYRESTONE, TinkersFluidRegistry.SKELETAL, TinkersFluidRegistry.VARSIUM});
        if (ConfigurationUtil.IntegrationsConfig.tinkersConstruct.modifiers) {
            TinkerClientEventHandler.registerModifierModels(new IModifier[]{Traits.AIR_BLADE, Traits.BUTCHERER, Traits.CREEPIFIED, Traits.MONEYBAGS, Traits.REFREEZING, Traits.SURPRISE_ME});
        }
    }

    private static void registerModifierModels(IModifier ... modifiers) {
        for (IModifier modifier : modifiers) {
            ModelRegisterUtil.registerModifierModel((IModifier)modifier, (ResourceLocation)new ResourceLocation("aoa3", "models/item/tconstruct/modifiers/" + modifier.getIdentifier()));
        }
    }

    private static void registerFluidModels(Fluid ... fluids) {
        for (Fluid fluid : fluids) {
            Block fluidBlock = fluid.getBlock();
            if (fluidBlock == null) continue;
            Item fluidItem = Item.func_150898_a((Block)fluidBlock);
            BasicFluidBlock.FluidStateMapper mapper = new BasicFluidBlock.FluidStateMapper(fluid);
            if (fluidItem != Items.field_190931_a) {
                ModelLoader.setCustomMeshDefinition((Item)fluidItem, (ItemMeshDefinition)mapper);
            }
            ModelLoader.setCustomStateMapper((Block)fluidBlock, (IStateMapper)mapper);
        }
    }
}

