/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.hooks.tconstruct;

import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.tslat.aoa3.advent.AdventOfAscension;
import net.tslat.aoa3.common.registration.ItemRegister;
import net.tslat.aoa3.common.registration.MaterialsRegister;
import net.tslat.aoa3.entity.mobs.overworld.EntityCharger;
import net.tslat.aoa3.entity.mobs.overworld.EntityDesertCharger;
import net.tslat.aoa3.entity.mobs.overworld.EntityHillCharger;
import net.tslat.aoa3.entity.mobs.overworld.EntityKingCharger;
import net.tslat.aoa3.entity.mobs.overworld.EntitySeaCharger;
import net.tslat.aoa3.entity.mobs.overworld.EntitySnowCharger;
import net.tslat.aoa3.entity.mobs.overworld.EntitySwampCharger;
import net.tslat.aoa3.entity.mobs.overworld.EntityVoidCharger;
import net.tslat.aoa3.entity.mobs.overworld.soulscurry.EntityGhostlyCharger;
import net.tslat.aoa3.hooks.tconstruct.TinkerClientEventHandler;
import net.tslat.aoa3.hooks.tconstruct.TinkersFluidRegistry;
import net.tslat.aoa3.hooks.tconstruct.traits.Traits;
import net.tslat.aoa3.library.Enums;
import net.tslat.aoa3.utils.ConfigurationUtil;
import net.tslat.aoa3.utils.ModUtil;
import slimeknights.tconstruct.common.config.Config;
import slimeknights.tconstruct.library.MaterialIntegration;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.materials.ArrowShaftMaterialStats;
import slimeknights.tconstruct.library.materials.BowMaterialStats;
import slimeknights.tconstruct.library.materials.ExtraMaterialStats;
import slimeknights.tconstruct.library.materials.FletchingMaterialStats;
import slimeknights.tconstruct.library.materials.HandleMaterialStats;
import slimeknights.tconstruct.library.materials.HeadMaterialStats;
import slimeknights.tconstruct.library.materials.IMaterialStats;
import slimeknights.tconstruct.library.materials.Material;
import slimeknights.tconstruct.library.traits.ITrait;
import slimeknights.tconstruct.tools.TinkerTraits;

public class TinkersMaterialRegistry {
    private static final Material BARONYTE = TinkersMaterialRegistry.compileMaterial("baronyte", 0xCE0000, (Fluid)TinkersFluidRegistry.BARONYTE, "ingotBaronyte");
    private static final Material BLAZIUM = TinkersMaterialRegistry.compileMaterial("blazium", 16735488, (Fluid)TinkersFluidRegistry.BLAZIUM, "ingotBlazium");
    private static final Material ELECANIUM = TinkersMaterialRegistry.compileMaterial("elecanium", 63993, (Fluid)TinkersFluidRegistry.ELECANIUM, "ingotElecanium");
    private static final Material EMBERSTONE = TinkersMaterialRegistry.compileMaterial("emberstone", 7018777, (Fluid)TinkersFluidRegistry.EMBERSTONE, "ingotEmberstone");
    private static final Material GHASTLY = TinkersMaterialRegistry.compileMaterial("ghastly", 0xCFF99F, (Fluid)TinkersFluidRegistry.GHASTLY, "ingotGhastly");
    private static final Material GHOULISH = TinkersMaterialRegistry.compileMaterial("ghoulish", 10070268, (Fluid)TinkersFluidRegistry.GHOULISH, "ingotGhoulish");
    private static final Material LIMONITE = TinkersMaterialRegistry.compileMaterial("limonite", 16757248, (Fluid)TinkersFluidRegistry.LIMONITE, "ingotLimonite");
    private static final Material LUNAR = TinkersMaterialRegistry.compileMaterial("lunar", 16747711, (Fluid)TinkersFluidRegistry.LUNAR, "ingotLunar");
    private static final Material LYON = TinkersMaterialRegistry.compileMaterial("lyon", 11043072, (Fluid)TinkersFluidRegistry.LYON, "ingotLyon");
    private static final Material MYSTITE = TinkersMaterialRegistry.compileMaterial("mystite", 7077822, (Fluid)TinkersFluidRegistry.MYSTITE, "ingotMystite");
    private static final Material ROSITE = TinkersMaterialRegistry.compileMaterial("rosite", 13833014, (Fluid)TinkersFluidRegistry.ROSITE, "ingotRosite");
    private static final Material SHYRESTONE = TinkersMaterialRegistry.compileMaterial("shyrestone", 39932, (Fluid)TinkersFluidRegistry.SHYRESTONE, "ingotShyrestone");
    private static final Material SKELETAL = TinkersMaterialRegistry.compileMaterial("skeletal", 16771232, (Fluid)TinkersFluidRegistry.SKELETAL, "ingotSkeletal");
    private static final Material VARSIUM = TinkersMaterialRegistry.compileMaterial("varsium", 13011503, (Fluid)TinkersFluidRegistry.SKELETAL, "ingotVarsium");
    private static final Material CHARGER = TinkersMaterialRegistry.compileMaterial("charger", 16770304);
    private static final Material LIMONITE_ROD = TinkersMaterialRegistry.compileMaterial("limonite_rod", 16757248);
    private static final Material TORN_CLOTH = TinkersMaterialRegistry.compileMaterial("torn_cloth", 7170392);

    public static void preInit() {
        TinkersMaterialRegistry.setMaterialStats();
        TinkersMaterialRegistry.integrateMaterials();
        if (ModUtil.isClient()) {
            MinecraftForge.EVENT_BUS.register((Object)new TinkerClientEventHandler());
        }
    }

    public static void init() {
        CHARGER.addItem((Item)ItemRegister.RAW_CHARGER_SHANK, 4, 1);
        CHARGER.addItem((Item)ItemRegister.CHARGER_SHANK, 3, 1);
        CHARGER.setRepresentativeItem(new ItemStack((Item)ItemRegister.RAW_CHARGER_SHANK, 6));
        LIMONITE_ROD.addItem((Item)ItemRegister.LIMONITE_ROD);
        LIMONITE_ROD.setRepresentativeItem((Item)ItemRegister.LIMONITE_ROD);
        TORN_CLOTH.addItem((Item)ItemRegister.TORN_CLOTH, 1, 288);
        TORN_CLOTH.setRepresentativeItem((Item)ItemRegister.TORN_CLOTH);
        TinkersMaterialRegistry.doSlimeIslandBlacklist();
        TinkersMaterialRegistry.registerCustomMelting();
        TinkersMaterialRegistry.applyTraits();
    }

    private static void doSlimeIslandBlacklist() {
        ArrayList<Integer> aoaSlimeIslandBlacklist = new ArrayList<Integer>();
        for (String st : ConfigurationUtil.IntegrationsConfig.tinkersConstruct.slimeIslandBlacklist) {
            try {
                Enums.Dimensions dim = Enums.Dimensions.valueOf(st.toUpperCase().replace(" ", "_"));
                if (dim == Enums.Dimensions.OVERWORLD || dim == Enums.Dimensions.THE_END || dim == Enums.Dimensions.NETHER) continue;
                aoaSlimeIslandBlacklist.add(ConfigurationUtil.getDimensionId(dim));
            }
            catch (IllegalArgumentException ex) {
                AdventOfAscension.logOptionalMessage("Invalid dimension name \"" + st + "\" found in AoA Slime Island Blacklist. Skipping.");
            }
        }
        int[] newSlimeIslandBlacklist = new int[Config.slimeIslandBlacklist.length + aoaSlimeIslandBlacklist.size()];
        System.arraycopy(Config.slimeIslandBlacklist, 0, newSlimeIslandBlacklist, 0, Config.slimeIslandBlacklist.length);
        for (int i = 0; i < aoaSlimeIslandBlacklist.size(); ++i) {
            newSlimeIslandBlacklist[i + Config.slimeIslandBlacklist.length] = (Integer)aoaSlimeIslandBlacklist.get(i);
        }
        Config.slimeIslandBlacklist = newSlimeIslandBlacklist;
    }

    private static void setMaterialStats() {
        TinkerRegistry.addMaterialStats((Material)BARONYTE, (IMaterialStats)new HeadMaterialStats(900, 5.3f, 3.75f, 4), (IMaterialStats[])new IMaterialStats[]{new HandleMaterialStats(1.15f, 130), new ExtraMaterialStats(220), new BowMaterialStats(0.5f, 1.6f, 4.0f)});
        TinkerRegistry.addMaterialStats((Material)BLAZIUM, (IMaterialStats)new HeadMaterialStats(800, 4.5f, 3.6f, 4), (IMaterialStats[])new IMaterialStats[]{new HandleMaterialStats(0.7f, 60), new ExtraMaterialStats(70), new BowMaterialStats(0.6f, 1.2f, 3.5f)});
        TinkerRegistry.addMaterialStats((Material)ELECANIUM, (IMaterialStats)new HeadMaterialStats(600, 8.3f, 6.1f, 6), (IMaterialStats[])new IMaterialStats[]{new HandleMaterialStats(2.0f, -400), new ExtraMaterialStats(30), new BowMaterialStats(0.82f, 1.8f, 7.7f)});
        TinkerRegistry.addMaterialStats((Material)EMBERSTONE, (IMaterialStats)new HeadMaterialStats(640, 4.0f, 3.8f, MaterialsRegister.TOOL_EMBERSTONE.func_77996_d()), (IMaterialStats[])new IMaterialStats[]{new HandleMaterialStats(0.65f, 100), new ExtraMaterialStats(200), new BowMaterialStats(0.65f, 1.3f, 4.2f)});
        TinkerRegistry.addMaterialStats((Material)GHASTLY, (IMaterialStats)new HeadMaterialStats(730, 4.7f, 4.5f, 6), (IMaterialStats[])new IMaterialStats[]{new HandleMaterialStats(0.9f, 30), new ExtraMaterialStats(50), new BowMaterialStats(0.73f, 1.55f, 4.6f)});
        TinkerRegistry.addMaterialStats((Material)GHOULISH, (IMaterialStats)new HeadMaterialStats(1000, 3.9f, 3.2f, 6), (IMaterialStats[])new IMaterialStats[]{new HandleMaterialStats(1.3f, 45), new ExtraMaterialStats(420), new BowMaterialStats(0.74f, 0.6f, 3.2f)});
        TinkerRegistry.addMaterialStats((Material)LIMONITE, (IMaterialStats)new HeadMaterialStats(250, 3.0f, 2.8f, MaterialsRegister.TOOL_LIMONITE.func_77996_d()), (IMaterialStats[])new IMaterialStats[]{new HandleMaterialStats(0.6f, 70), new ExtraMaterialStats(75), new BowMaterialStats(0.4f, 0.6f, 0.0f)});
        TinkerRegistry.addMaterialStats((Material)LUNAR, (IMaterialStats)new HeadMaterialStats(660, 3.8f, 2.0f, 6), (IMaterialStats[])new IMaterialStats[]{new HandleMaterialStats(0.9f, 90), new ExtraMaterialStats(130), new BowMaterialStats(0.6f, 1.15f, 3.4f)});
        TinkerRegistry.addMaterialStats((Material)LYON, (IMaterialStats)new HeadMaterialStats(840, 6.2f, 4.0f, 6), (IMaterialStats[])new IMaterialStats[]{new HandleMaterialStats(1.05f, 55), new ExtraMaterialStats(380), new BowMaterialStats(0.5f, 1.5f, 3.75f)});
        TinkerRegistry.addMaterialStats((Material)MYSTITE, (IMaterialStats)new HeadMaterialStats(760, 3.65f, 4.3f, 6), (IMaterialStats[])new IMaterialStats[]{new HandleMaterialStats(1.05f, 105), new ExtraMaterialStats(80), new BowMaterialStats(0.65f, 1.4f, 3.0f)});
        TinkerRegistry.addMaterialStats((Material)ROSITE, (IMaterialStats)new HeadMaterialStats(400, 3.4f, 3.4f, MaterialsRegister.TOOL_ROSITE.func_77996_d()), (IMaterialStats[])new IMaterialStats[]{new HandleMaterialStats(0.95f, 20), new ExtraMaterialStats(55), new BowMaterialStats(0.54f, 0.8f, 1.0f)});
        TinkerRegistry.addMaterialStats((Material)SHYRESTONE, (IMaterialStats)new HeadMaterialStats(640, 13.0f, 3.6f, 6), (IMaterialStats[])new IMaterialStats[]{new HandleMaterialStats(1.0f, 0), new ExtraMaterialStats(315), new BowMaterialStats(0.65f, 1.3f, 3.2f)});
        TinkerRegistry.addMaterialStats((Material)SKELETAL, (IMaterialStats)new HeadMaterialStats(610, 10.0f, 4.3f, MaterialsRegister.TOOL_SKELETAL.func_77996_d()), (IMaterialStats[])new IMaterialStats[]{new HandleMaterialStats(0.75f, 140), new ExtraMaterialStats(290), new BowMaterialStats(1.15f, 1.4f, 2.6f)});
        TinkerRegistry.addMaterialStats((Material)VARSIUM, (IMaterialStats)new HeadMaterialStats(870, 5.2f, 3.9f, 4), (IMaterialStats[])new IMaterialStats[]{new HandleMaterialStats(1.0f, 300), new ExtraMaterialStats(250), new BowMaterialStats(0.55f, 1.5f, 3.8f)});
        TinkerRegistry.addMaterialStats((Material)CHARGER, (IMaterialStats)new HeadMaterialStats(110, 2.4f, 2.5f, 0), (IMaterialStats[])new IMaterialStats[]{new HandleMaterialStats(0.5f, 0), new ExtraMaterialStats(18)});
        TinkerRegistry.addMaterialStats((Material)LIMONITE_ROD, (IMaterialStats)new ArrowShaftMaterialStats(2.0f, -20));
        TinkerRegistry.addMaterialStats((Material)TORN_CLOTH, (IMaterialStats)new FletchingMaterialStats(0.35f, 2.25f));
    }

    private static void applyTraits() {
        BARONYTE.addTrait((ITrait)Traits.BARON);
        BLAZIUM.addTrait((ITrait)Traits.FLAMING_FURY);
        BLAZIUM.addTrait((ITrait)Traits.INFERNAL_ENERGY, "head");
        CHARGER.addTrait((ITrait)Traits.TWEETING);
        ELECANIUM.addTrait((ITrait)Traits.RUNIC_1);
        ELECANIUM.addTrait((ITrait)Traits.RUNIC_2, "head");
        EMBERSTONE.addTrait((ITrait)TinkerTraits.autosmelt);
        EMBERSTONE.addTrait((ITrait)Traits.BLAZING);
        GHASTLY.addTrait((ITrait)Traits.ANTI_AIR_1);
        GHASTLY.addTrait((ITrait)Traits.ANTI_AIR_2, "head");
        GHASTLY.addTrait((ITrait)Traits.ETHEREAL_MINER);
        GHOULISH.addTrait((ITrait)Traits.SOUL_HARVEST);
        GHOULISH.addTrait((ITrait)Traits.SOUL_SAP);
        LIMONITE.addTrait((ITrait)Traits.DISCOUNTED);
        LUNAR.addTrait((ITrait)Traits.COUNTERWEIGHT_1);
        LUNAR.addTrait((ITrait)Traits.COUNTERWEIGHT_2, "head");
        LYON.addTrait((ITrait)TinkerTraits.magnetic);
        LYON.addTrait((ITrait)TinkerTraits.magnetic2, "head");
        MYSTITE.addTrait((ITrait)Traits.LACED);
        MYSTITE.addTrait((ITrait)Traits.TOXIC, "head");
        ROSITE.addTrait((ITrait)TinkerTraits.writable2, "head");
        SHYRESTONE.addTrait((ITrait)Traits.SHYRE_SYNTHESIS);
        SKELETAL.addTrait((ITrait)Traits.BONE_SHOCK);
        SKELETAL.addTrait((ITrait)Traits.HIGH_IN_CALCIUM);
        VARSIUM.addTrait((ITrait)Traits.EVIL_PRESSURE);
        LIMONITE_ROD.addTrait((ITrait)Traits.DISCOUNTED);
    }

    private static void integrateMaterials() {
        TinkersMaterialRegistry.integrate(BARONYTE, (Fluid)TinkersFluidRegistry.BARONYTE, "Baronyte", true);
        TinkersMaterialRegistry.integrate(BLAZIUM, (Fluid)TinkersFluidRegistry.BLAZIUM, "Blazium", true);
        TinkersMaterialRegistry.integrate(ELECANIUM, (Fluid)TinkersFluidRegistry.ELECANIUM, "Elecanium", true);
        TinkersMaterialRegistry.integrate(EMBERSTONE, (Fluid)TinkersFluidRegistry.EMBERSTONE, "Emberstone", true);
        TinkersMaterialRegistry.integrate(GHASTLY, (Fluid)TinkersFluidRegistry.GHASTLY, "Ghastly", true);
        TinkersMaterialRegistry.integrate(GHOULISH, (Fluid)TinkersFluidRegistry.GHOULISH, "Ghoulish", true);
        TinkersMaterialRegistry.integrate(LIMONITE, (Fluid)TinkersFluidRegistry.LIMONITE, "Limonite", true);
        TinkersMaterialRegistry.integrate(LUNAR, (Fluid)TinkersFluidRegistry.LUNAR, "Lunar", true);
        TinkersMaterialRegistry.integrate(LYON, (Fluid)TinkersFluidRegistry.LYON, "Lyon", true);
        TinkersMaterialRegistry.integrate(MYSTITE, (Fluid)TinkersFluidRegistry.MYSTITE, "Mystite", true);
        TinkersMaterialRegistry.integrate(ROSITE, (Fluid)TinkersFluidRegistry.ROSITE, "Rosite", true);
        TinkersMaterialRegistry.integrate(SHYRESTONE, (Fluid)TinkersFluidRegistry.SHYRESTONE, "Shyrestone", true);
        TinkersMaterialRegistry.integrate(SKELETAL, (Fluid)TinkersFluidRegistry.SKELETAL, "Skeletal", true);
        TinkersMaterialRegistry.integrate(VARSIUM, (Fluid)TinkersFluidRegistry.VARSIUM, "Varsium", true);
        TinkersMaterialRegistry.integrate(CHARGER, (Fluid)TinkersFluidRegistry.CHARGER);
        TinkersMaterialRegistry.integrate(LIMONITE_ROD);
        TinkersMaterialRegistry.integrate(TORN_CLOTH);
    }

    public static void registerSmelting(Item smeltItem, Fluid fluid, int amount) {
        TinkerRegistry.registerMelting((Item)smeltItem, (Fluid)fluid, (int)amount);
    }

    private static void registerCustomMelting() {
        TinkersMaterialRegistry.registerSmelting((Item)ItemRegister.CHARGER_SHANK, (Fluid)TinkersFluidRegistry.CHARGER, 20);
        TinkersMaterialRegistry.registerSmelting((Item)ItemRegister.RAW_CHARGER_SHANK, (Fluid)TinkersFluidRegistry.CHARGER, 17);
        TinkerRegistry.registerEntityMelting(EntityCharger.class, (FluidStack)new FluidStack((Fluid)TinkersFluidRegistry.CHARGER, 6));
        TinkerRegistry.registerEntityMelting(EntityKingCharger.class, (FluidStack)new FluidStack((Fluid)TinkersFluidRegistry.CHARGER, 16));
        TinkerRegistry.registerEntityMelting(EntityDesertCharger.class, (FluidStack)new FluidStack((Fluid)TinkersFluidRegistry.CHARGER, 6));
        TinkerRegistry.registerEntityMelting(EntityHillCharger.class, (FluidStack)new FluidStack((Fluid)TinkersFluidRegistry.CHARGER, 6));
        TinkerRegistry.registerEntityMelting(EntityGhostlyCharger.class, (FluidStack)new FluidStack((Fluid)TinkersFluidRegistry.CHARGER, 6));
        TinkerRegistry.registerEntityMelting(EntitySeaCharger.class, (FluidStack)new FluidStack((Fluid)TinkersFluidRegistry.CHARGER, 6));
        TinkerRegistry.registerEntityMelting(EntitySwampCharger.class, (FluidStack)new FluidStack((Fluid)TinkersFluidRegistry.CHARGER, 6));
        TinkerRegistry.registerEntityMelting(EntityVoidCharger.class, (FluidStack)new FluidStack((Fluid)TinkersFluidRegistry.CHARGER, 6));
        TinkerRegistry.registerEntityMelting(EntitySnowCharger.class, (FluidStack)new FluidStack((Fluid)TinkersFluidRegistry.CHARGER, 6));
    }

    private static void integrate(Material material) {
        TinkerRegistry.integrate((Material)material).preInit();
    }

    private static void integrate(Material material, Fluid fluid) {
        TinkerRegistry.integrate((Material)material, (Fluid)fluid).preInit();
    }

    private static void integrate(Material material, Fluid fluid, String oreSuffix, boolean toolForgeMaterial) {
        MaterialIntegration integration = new MaterialIntegration(material, fluid, oreSuffix);
        if (toolForgeMaterial) {
            integration.toolforge();
        }
        TinkerRegistry.integrate((MaterialIntegration)integration).preInit();
    }

    private static Material compileMaterial(String name, int colour) {
        return new Material(name, colour);
    }

    private static Material compileMaterial(String name, int colour, @Nullable Fluid fluid, @Nullable String ingotOreDict) {
        Material mat = new Material(name, colour);
        if (fluid != null) {
            mat.setFluid(fluid);
        }
        if (ingotOreDict != null) {
            mat.addItemIngot(ingotOreDict);
        }
        return mat;
    }
}

