/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.hooks.tconstruct.modifiers;

import com.google.common.collect.ImmutableList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.tslat.aoa3.hooks.tconstruct.traits.Traits;
import slimeknights.tconstruct.library.Util;
import slimeknights.tconstruct.library.modifiers.ModifierAspect;
import slimeknights.tconstruct.library.modifiers.ModifierTrait;
import slimeknights.tconstruct.library.utils.ToolHelper;
import slimeknights.tconstruct.tools.melee.item.BroadSword;

public class ModAirBlade
extends ModifierTrait {
    public ModAirBlade() {
        super("air_blade", 0xFFFDD8, 3, 1);
        this.addAspects(new ModifierAspect[]{ModifierAspect.weaponOnly});
    }

    public boolean canApplyCustom(ItemStack stack) {
        return super.canApplyCustom(stack) && stack.func_77973_b() instanceof BroadSword;
    }

    public void afterHit(ItemStack tool, EntityLivingBase player, EntityLivingBase target, float damageDealt, boolean wasCritical, boolean wasHit) {
        if (wasHit && !ToolHelper.isBroken((ItemStack)tool) && tool.func_77973_b() instanceof BroadSword) {
            if (player.field_70143_R > 0.0f || !player.field_70122_E || player.func_70051_ag() || player.func_70617_f_() || player.func_70090_H() || player.func_184218_aH()) {
                return;
            }
            if (player instanceof EntityPlayer && (double)((EntityPlayer)player).func_184825_o(0.5f) <= 0.9) {
                return;
            }
            if (player.field_70140_Q - player.field_70141_P >= player.func_70689_ay()) {
                return;
            }
            int modStage = Traits.getModifierStage(tool, this);
            float damage = damageDealt * ((float)modStage / (float)(modStage + 2));
            for (EntityLivingBase entity : player.func_130014_f_().func_72872_a(EntityLivingBase.class, target.func_174813_aQ().func_72321_a(1.0, 0.25, 1.0))) {
                if (entity == player || entity == target || player.func_184191_r((Entity)entity) || !(player.func_70068_e((Entity)target) < 9.0)) continue;
                entity.func_70097_a(player instanceof EntityPlayer ? DamageSource.func_76365_a((EntityPlayer)((EntityPlayer)player)) : DamageSource.func_76358_a((EntityLivingBase)player), damage);
            }
        }
    }

    public List<String> getExtraInfo(ItemStack tool, NBTTagCompound modifierTag) {
        int modStage = Traits.getModifierStage(tool, this);
        float percentBoost = (float)modStage / (float)(modStage + 2);
        return ImmutableList.of((Object)Util.translateFormatted((String)String.format("modifier.%s.extra", this.getModifierIdentifier()), (Object[])new Object[]{Util.dfPercent.format(percentBoost)}));
    }
}

