/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.hooks.thermalexpansion;

import cofh.thermalexpansion.util.managers.device.TapperManager;
import cofh.thermalexpansion.util.managers.dynamo.EnervationManager;
import cofh.thermalexpansion.util.managers.dynamo.NumismaticManager;
import cofh.thermalexpansion.util.managers.machine.InsolatorManager;
import cofh.thermalexpansion.util.managers.machine.PrecipitatorManager;
import cofh.thermalexpansion.util.managers.machine.PulverizerManager;
import cofh.thermalexpansion.util.managers.machine.RefineryManager;
import cofh.thermalexpansion.util.managers.machine.SawmillManager;
import cofh.thermalfoundation.init.TFFluids;
import cofh.thermalfoundation.init.TFItems;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.tslat.aoa3.block.functional.crops.CropBlock;
import net.tslat.aoa3.block.generation.plants.FlowerBlock;
import net.tslat.aoa3.block.generation.plants.GenericPlantBlock;
import net.tslat.aoa3.block.generation.plants.PlantStackable;
import net.tslat.aoa3.block.generation.wood.LogBlock;
import net.tslat.aoa3.common.registration.BlockRegister;
import net.tslat.aoa3.common.registration.FluidsRegister;
import net.tslat.aoa3.common.registration.ItemRegister;
import net.tslat.aoa3.utils.ConfigurationUtil;

public class ThermalExpansionCompat {
    public static void init() {
        ThermalExpansionCompat.addPulverizerRecipes();
        ThermalExpansionCompat.addSawmillRecipes();
        ThermalExpansionCompat.addPhytogenicInsolatorRecipes();
        ThermalExpansionCompat.addFractionatingStillRecipes();
        ThermalExpansionCompat.addGlacialPrecipitatorRecipes();
        ThermalExpansionCompat.addArborealExtractorRecipes();
        ThermalExpansionCompat.addEnervationDynamoRecipes();
        ThermalExpansionCompat.addNumismaticDynamoRecipes();
    }

    private static void addPulverizerRecipes() {
        if (!ConfigurationUtil.IntegrationsConfig.thermalExpansion.pulverizerRecipes) {
            return;
        }
        PulverizerManager.addRecipe((int)3000, (ItemStack)new ItemStack((Item)ItemRegister.ARCHERGUN_FRAME), (ItemStack)new ItemStack((Item)ItemRegister.SCRAP_METAL), (ItemStack)new ItemStack(Items.field_151042_j), (int)20);
        PulverizerManager.addRecipe((int)3000, (ItemStack)new ItemStack((Item)ItemRegister.BLASTER_FRAME), (ItemStack)new ItemStack((Item)ItemRegister.SCRAP_METAL), (ItemStack)new ItemStack(Items.field_151042_j), (int)20);
        PulverizerManager.addRecipe((int)3000, (ItemStack)new ItemStack((Item)ItemRegister.BOOTS_FRAME), (ItemStack)new ItemStack((Item)ItemRegister.SCRAP_METAL), (ItemStack)new ItemStack(Items.field_151042_j), (int)20);
        PulverizerManager.addRecipe((int)3000, (ItemStack)new ItemStack((Item)ItemRegister.LEGGINGS_FRAME), (ItemStack)new ItemStack((Item)ItemRegister.SCRAP_METAL), (ItemStack)new ItemStack(Items.field_151042_j), (int)20);
        PulverizerManager.addRecipe((int)3000, (ItemStack)new ItemStack((Item)ItemRegister.CHESTPLATE_FRAME), (ItemStack)new ItemStack((Item)ItemRegister.SCRAP_METAL), (ItemStack)new ItemStack(Items.field_151042_j), (int)20);
        PulverizerManager.addRecipe((int)3000, (ItemStack)new ItemStack((Item)ItemRegister.HELMET_FRAME), (ItemStack)new ItemStack((Item)ItemRegister.SCRAP_METAL), (ItemStack)new ItemStack(Items.field_151042_j), (int)20);
        PulverizerManager.addRecipe((int)3000, (ItemStack)new ItemStack((Item)ItemRegister.CANNON_FRAME), (ItemStack)new ItemStack((Item)ItemRegister.SCRAP_METAL), (ItemStack)new ItemStack(Items.field_151042_j), (int)20);
        PulverizerManager.addRecipe((int)3000, (ItemStack)new ItemStack((Item)ItemRegister.GUN_FRAME), (ItemStack)new ItemStack((Item)ItemRegister.SCRAP_METAL), (ItemStack)new ItemStack(Items.field_151042_j), (int)20);
        PulverizerManager.addRecipe((int)3000, (ItemStack)new ItemStack((Item)ItemRegister.SHOTGUN_FRAME), (ItemStack)new ItemStack((Item)ItemRegister.SCRAP_METAL), (ItemStack)new ItemStack(Items.field_151042_j), (int)20);
        PulverizerManager.addRecipe((int)3000, (ItemStack)new ItemStack((Item)ItemRegister.SNIPER_FRAME), (ItemStack)new ItemStack((Item)ItemRegister.SCRAP_METAL), (ItemStack)new ItemStack(Items.field_151042_j), (int)20);
        PulverizerManager.addRecipe((int)2000, (ItemStack)new ItemStack((Item)ItemRegister.HARDENED_CONFETTI_BALL), (ItemStack)new ItemStack((Item)ItemRegister.CONFETTI_PILE, 4));
        PulverizerManager.addRecipe((int)2000, (ItemStack)new ItemStack((Block)BlockRegister.GINGERBREAD), (ItemStack)new ItemStack((Item)ItemRegister.GINGERBREAD_COOKIE, 2), (ItemStack)new ItemStack((Item)ItemRegister.GINGERBREAD_WING, 2), (int)50);
        PulverizerManager.addRecipe((int)3000, (ItemStack)new ItemStack((Block)BlockRegister.CHOCOLATE_BLOCK), (ItemStack)new ItemStack(Items.field_151100_aR, 2, 3), (ItemStack)new ItemStack(Items.field_151102_aT, 3), (int)40);
        PulverizerManager.addRecipe((int)3000, (ItemStack)new ItemStack((Block)BlockRegister.DARK_CHOCOLATE_BLOCK), (ItemStack)new ItemStack(Items.field_151100_aR, 2, 3), (ItemStack)new ItemStack(Items.field_151102_aT, 3), (int)40);
        PulverizerManager.addRecipe((int)6000, (ItemStack)new ItemStack((Item)ItemRegister.GOLD_COIN), (ItemStack)new ItemStack(Items.field_151043_k, 3));
        PulverizerManager.addRecipe((int)4000, (ItemStack)new ItemStack((Item)ItemRegister.ARMOUR_PLATING), (ItemStack)new ItemStack((Item)ItemRegister.CHITIN, 4));
    }

    private static void addSawmillRecipes() {
        if (!ConfigurationUtil.IntegrationsConfig.thermalExpansion.sawmillRecipes) {
            return;
        }
        for (Block block : ForgeRegistries.BLOCKS.getValuesCollection()) {
            if (!(block instanceof PlantStackable) && !(block instanceof GenericPlantBlock) || block.func_176223_P().func_185904_a() != Material.field_151585_k) continue;
            SawmillManager.addRecipe((int)2000, (ItemStack)new ItemStack(block, 8), (ItemStack)new ItemStack((Item)TFItems.itemMaterial, 1, 816));
        }
        SawmillManager.addRecipe((int)2000, (ItemStack)new ItemStack((Block)BlockRegister.CREEP_VINES, 8), (ItemStack)new ItemStack((Item)TFItems.itemMaterial, 1, 816));
    }

    private static void addPhytogenicInsolatorRecipes() {
        if (!ConfigurationUtil.IntegrationsConfig.thermalExpansion.phytogenicInsolatorRecipes) {
            return;
        }
        for (Block block : ForgeRegistries.BLOCKS.getValuesCollection()) {
            if (block instanceof CropBlock) {
                Item seeds;
                CropBlock crop = (CropBlock)block;
                if (!(crop.getSeeds() instanceof Item) || (seeds = (Item)crop.getSeeds()) == null) continue;
                InsolatorManager.addRecipe((int)5000, (ItemStack)new ItemStack((Item)TFItems.itemFertilizer), (ItemStack)new ItemStack(seeds), (ItemStack)new ItemStack(crop.func_149865_P(), 2), (ItemStack)new ItemStack(seeds), (int)110);
                InsolatorManager.addRecipe((int)7500, (ItemStack)new ItemStack((Item)TFItems.itemFertilizer, 1, 1), (ItemStack)new ItemStack(seeds), (ItemStack)new ItemStack(crop.func_149865_P(), 4), (ItemStack)new ItemStack(seeds), (int)125);
                InsolatorManager.addRecipe((int)10000, (ItemStack)new ItemStack((Item)TFItems.itemFertilizer, 1, 2), (ItemStack)new ItemStack(seeds), (ItemStack)new ItemStack(crop.func_149865_P(), 6), (ItemStack)new ItemStack(seeds), (int)150);
                continue;
            }
            if (!(block instanceof FlowerBlock)) continue;
            InsolatorManager.addRecipe((int)5000, (ItemStack)new ItemStack((Item)TFItems.itemFertilizer), (ItemStack)new ItemStack(block), (ItemStack)new ItemStack(block, 3));
            InsolatorManager.addRecipe((int)7500, (ItemStack)new ItemStack((Item)TFItems.itemFertilizer, 1, 1), (ItemStack)new ItemStack(block), (ItemStack)new ItemStack(block, 6));
            InsolatorManager.addRecipe((int)10000, (ItemStack)new ItemStack((Item)TFItems.itemFertilizer, 1, 2), (ItemStack)new ItemStack(block), (ItemStack)new ItemStack(block, 9));
        }
    }

    private static void addFractionatingStillRecipes() {
        if (!ConfigurationUtil.IntegrationsConfig.thermalExpansion.fractionatingStillRecipes) {
            return;
        }
        RefineryManager.addRecipe((int)6000, (FluidStack)new FluidStack((Fluid)FluidsRegister.CANDIED_WATER, 200), (FluidStack)new FluidStack(FluidRegistry.WATER, 100), (ItemStack)new ItemStack(Items.field_151102_aT, 2));
    }

    private static void addGlacialPrecipitatorRecipes() {
        if (!ConfigurationUtil.IntegrationsConfig.thermalExpansion.glacialPrecipitatorRecipes) {
            return;
        }
        PrecipitatorManager.addRecipe((int)6000, (ItemStack)new ItemStack((Item)ItemRegister.ICE_CRYSTAL), (FluidStack)new FluidStack(FluidRegistry.WATER, 4000));
    }

    private static void addArborealExtractorRecipes() {
        if (!ConfigurationUtil.IntegrationsConfig.thermalExpansion.arborealExtractorRecipes) {
            return;
        }
        for (Block block : ForgeRegistries.BLOCKS.getValuesCollection()) {
            if (!(block instanceof LogBlock)) continue;
            TapperManager.addStandardMapping((ItemStack)new ItemStack(block), (FluidStack)new FluidStack(TFFluids.fluidResin, 50));
        }
        TapperManager.addStandardMapping((ItemStack)new ItemStack((Block)BlockRegister.AQUA_COTTON_CANDY), (FluidStack)new FluidStack((Fluid)FluidsRegister.CANDIED_WATER, 200));
        TapperManager.addStandardMapping((ItemStack)new ItemStack((Block)BlockRegister.PINK_COTTON_CANDY), (FluidStack)new FluidStack((Fluid)FluidsRegister.CANDIED_WATER, 200));
    }

    private static void addEnervationDynamoRecipes() {
        if (!ConfigurationUtil.IntegrationsConfig.thermalExpansion.enervationDynamoRecipes) {
            return;
        }
        EnervationManager.addFuel((ItemStack)new ItemStack((Item)ItemRegister.POWER_CORE), (int)1200000);
        EnervationManager.addFuel((ItemStack)new ItemStack((Item)ItemRegister.RUNIC_ENERGY), (int)900000);
        EnervationManager.addFuel((ItemStack)new ItemStack((Item)ItemRegister.POWER_RUNE), (int)30000);
        EnervationManager.addFuel((ItemStack)new ItemStack((Item)ItemRegister.ENERGY_RUNE), (int)40000);
    }

    private static void addNumismaticDynamoRecipes() {
        if (!ConfigurationUtil.IntegrationsConfig.thermalExpansion.numismaticDynamoRecipes) {
            return;
        }
        NumismaticManager.addFuel((ItemStack)new ItemStack((Item)ItemRegister.COPPER_COIN), (int)20000);
        NumismaticManager.addFuel((ItemStack)new ItemStack((Item)ItemRegister.SILVER_COIN), (int)200000);
        NumismaticManager.addFuel((ItemStack)new ItemStack((Item)ItemRegister.GOLD_COIN), (int)700000);
        NumismaticManager.addFuel((ItemStack)new ItemStack((Item)ItemRegister.LUNAVER_COIN), (int)2000000);
    }
}

