/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.item.armour;

import java.util.HashSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.tslat.aoa3.common.registration.MaterialsRegister;
import net.tslat.aoa3.item.armour.AdventArmour;
import net.tslat.aoa3.library.Enums;
import net.tslat.aoa3.utils.ItemUtil;
import net.tslat.aoa3.utils.player.PlayerDataManager;

public class CandyArmour
extends AdventArmour {
    public CandyArmour(String name, String registryName, EntityEquipmentSlot slot) {
        super(MaterialsRegister.ARMOUR_CANDY, name, registryName, slot);
    }

    @Override
    public Enums.ArmourSets setType() {
        return Enums.ArmourSets.CANDY;
    }

    @Override
    public void onEffectTick(PlayerDataManager plData, @Nullable HashSet<EntityEquipmentSlot> slots) {
        if (plData.player().func_71024_bL().func_75121_c() && (slots == null || plData.equipment().isCooledDown(Enums.Counters.CANDY)) && this.findAndConsumeFood(plData.player())) {
            plData.equipment().setCooldown(Enums.Counters.CANDY, 12000 / (slots == null ? 4 : slots.size()));
        }
    }

    private boolean findAndConsumeFood(EntityPlayer player) {
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            ItemFood food;
            ItemStack stack = player.field_71071_by.func_70301_a(i);
            if (!(stack.func_77973_b() instanceof ItemFood) || (food = (ItemFood)stack.func_77973_b()).func_150905_g(stack) <= 0 || !(food.func_150906_h(stack) > 0.0f)) continue;
            player.field_71071_by.func_70299_a(i, stack.func_77973_b().func_77654_b(stack, player.field_70170_p, (EntityLivingBase)player));
            return true;
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag flag) {
        tooltip.add(ItemUtil.getFormattedDescriptionText("item.CandyArmour.desc.1", Enums.ItemDescriptionType.POSITIVE));
        tooltip.add(this.pieceEffectHeader());
        tooltip.add(ItemUtil.getFormattedDescriptionText("item.CandyArmour.desc.2", Enums.ItemDescriptionType.POSITIVE));
        tooltip.add(this.setEffectHeader());
        tooltip.add(ItemUtil.getFormattedDescriptionText("item.CandyArmour.desc.3", Enums.ItemDescriptionType.POSITIVE));
    }
}

