/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.item.armour;

import java.util.HashSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.material.Material;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.tslat.aoa3.common.registration.MaterialsRegister;
import net.tslat.aoa3.item.armour.AdventArmour;
import net.tslat.aoa3.library.Enums;
import net.tslat.aoa3.library.misc.AoAAttributes;
import net.tslat.aoa3.utils.EntityUtil;
import net.tslat.aoa3.utils.ItemUtil;
import net.tslat.aoa3.utils.player.PlayerDataManager;

public class SealordHelmet
extends AdventArmour {
    public SealordHelmet(String name, String registryName, EntityEquipmentSlot slot) {
        super(MaterialsRegister.ARMOUR_SEALORD_HELMET, name, registryName, slot);
    }

    @Override
    public Enums.ArmourSets setType() {
        return Enums.ArmourSets.ALL;
    }

    @Override
    public void onEffectTick(PlayerDataManager plData, @Nullable HashSet<EntityEquipmentSlot> slots) {
        EntityPlayer player = plData.player();
        if (player.func_70055_a(Material.field_151586_h)) {
            EntityUtil.applyAttributeModifierSafely((EntityLivingBase)plData.player(), SharedMonsterAttributes.field_188790_f, AoAAttributes.SEALORD_ATTACK_BUFF);
        } else {
            EntityUtil.removeAttributeModifier((EntityLivingBase)plData.player(), SharedMonsterAttributes.field_188790_f, AoAAttributes.SEALORD_ATTACK_BUFF);
        }
    }

    @Override
    public void onUnequip(PlayerDataManager plData, @Nullable EntityEquipmentSlot slot) {
        EntityUtil.removeAttributeModifier((EntityLivingBase)plData.player(), SharedMonsterAttributes.field_188790_f, AoAAttributes.SEALORD_ATTACK_BUFF);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag flag) {
        tooltip.add(ItemUtil.getFormattedDescriptionText("item.SealordHelmet.desc.1", Enums.ItemDescriptionType.POSITIVE));
        tooltip.add(this.anySetEffectHeader());
    }
}

