/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.item.armour;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.tslat.aoa3.common.registration.MaterialsRegister;
import net.tslat.aoa3.item.armour.AdventArmour;
import net.tslat.aoa3.library.Enums;
import net.tslat.aoa3.library.misc.AoAAttributes;
import net.tslat.aoa3.utils.EntityUtil;
import net.tslat.aoa3.utils.ItemUtil;
import net.tslat.aoa3.utils.player.PlayerDataManager;

public class SpeedArmour
extends AdventArmour {
    public SpeedArmour(String name, String registryName, EntityEquipmentSlot slot) {
        super(MaterialsRegister.ARMOUR_SPEED, name, registryName, slot);
    }

    @Override
    public Enums.ArmourSets setType() {
        return Enums.ArmourSets.SPEED;
    }

    @Override
    public void onEquip(PlayerDataManager plData, @Nullable EntityEquipmentSlot slot) {
        if (slot == null) {
            EntityUtil.applyAttributeModifierSafely((EntityLivingBase)plData.player(), SharedMonsterAttributes.field_111263_d, AoAAttributes.SPEED_ARMOUR_SET);
        } else {
            switch (slot) {
                case FEET: {
                    EntityUtil.applyAttributeModifierSafely((EntityLivingBase)plData.player(), SharedMonsterAttributes.field_111263_d, AoAAttributes.SPEED_ARMOUR_BOOTS);
                    break;
                }
                case LEGS: {
                    EntityUtil.applyAttributeModifierSafely((EntityLivingBase)plData.player(), SharedMonsterAttributes.field_111263_d, AoAAttributes.SPEED_ARMOUR_LEGS);
                    break;
                }
                case CHEST: {
                    EntityUtil.applyAttributeModifierSafely((EntityLivingBase)plData.player(), SharedMonsterAttributes.field_111263_d, AoAAttributes.SPEED_ARMOUR_BODY);
                    break;
                }
                case HEAD: {
                    EntityUtil.applyAttributeModifierSafely((EntityLivingBase)plData.player(), SharedMonsterAttributes.field_111263_d, AoAAttributes.SPEED_ARMOUR_HELMET);
                    break;
                }
            }
        }
    }

    @Override
    public void onUnequip(PlayerDataManager plData, @Nullable EntityEquipmentSlot slot) {
        if (slot == null) {
            EntityUtil.removeAttributeModifier((EntityLivingBase)plData.player(), SharedMonsterAttributes.field_111263_d, AoAAttributes.SPEED_ARMOUR_SET);
        } else {
            switch (slot) {
                case FEET: {
                    EntityUtil.removeAttributeModifier((EntityLivingBase)plData.player(), SharedMonsterAttributes.field_111263_d, AoAAttributes.SPEED_ARMOUR_BOOTS);
                    break;
                }
                case LEGS: {
                    EntityUtil.removeAttributeModifier((EntityLivingBase)plData.player(), SharedMonsterAttributes.field_111263_d, AoAAttributes.SPEED_ARMOUR_LEGS);
                    break;
                }
                case CHEST: {
                    EntityUtil.removeAttributeModifier((EntityLivingBase)plData.player(), SharedMonsterAttributes.field_111263_d, AoAAttributes.SPEED_ARMOUR_BODY);
                    break;
                }
                case HEAD: {
                    EntityUtil.removeAttributeModifier((EntityLivingBase)plData.player(), SharedMonsterAttributes.field_111263_d, AoAAttributes.SPEED_ARMOUR_HELMET);
                    break;
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag flag) {
        tooltip.add(this.pieceEffectHeader());
        tooltip.add(ItemUtil.getFormattedDescriptionText("item.SpeedArmour.desc.1", Enums.ItemDescriptionType.POSITIVE));
        tooltip.add(this.setEffectHeader());
        tooltip.add(ItemUtil.getFormattedDescriptionText("item.SpeedArmour.desc.1", Enums.ItemDescriptionType.POSITIVE));
    }
}

