/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.item.misc;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemWrittenBook;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.tslat.aoa3.advent.AdventOfAscension;
import net.tslat.aoa3.common.registration.CreativeTabsRegister;
import net.tslat.aoa3.common.registration.ItemRegister;
import net.tslat.aoa3.library.Enums;
import net.tslat.aoa3.utils.FileUtil;
import net.tslat.aoa3.utils.ItemUtil;
import net.tslat.aoa3.utils.StringUtil;

public class WornBook
extends ItemWrittenBook {
    private static final NBTTagCompound contents = new NBTTagCompound();

    public WornBook() {
        this.func_77655_b("WornBook");
        this.setRegistryName("aoa3:worn_book");
        this.func_77637_a(CreativeTabsRegister.MISC);
    }

    @SideOnly(value=Side.CLIENT)
    public static ItemStack getBook() {
        ItemStack stack = new ItemStack((Item)ItemRegister.WORN_BOOK, 1);
        stack.func_77982_d(WornBook.getBookContents());
        return stack;
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack bookStack = player.func_184586_b(hand);
        if (world.field_72995_K) {
            player.openGui((Object)AdventOfAscension.instance(), Enums.ModGuis.WORN_BOOK.guiId, world, (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v);
        } else if (ItemUtil.findItemInInventory(player, ItemRegister.BLANK_REALMSTONE) == -1) {
            ItemUtil.givePlayerItemOrDrop(player, new ItemStack((Item)ItemRegister.BLANK_REALMSTONE));
            player.func_145747_a((ITextComponent)StringUtil.getLocale("message.feedback.wornBook.droppedRealmstone"));
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)bookStack);
    }

    @SideOnly(value=Side.CLIENT)
    public static NBTTagCompound getBookContents() {
        contents.func_74778_a("author", StringUtil.getLocaleString("entity.aoa3.corrupted_traveller.name"));
        contents.func_74778_a("title", StringUtil.getLocaleString("item.WornBook.name"));
        String pageContents = FileUtil.getTextFromResourceFile("aoa3", "lang/aoa3/misc/" + FMLCommonHandler.instance().getCurrentLanguage() + "/worn_book.txt", "lang/aoa3/misc/en_us/worn_book.txt");
        if (pageContents == null) {
            return contents;
        }
        String[] lines = pageContents.split("\n");
        NBTTagList pages = new NBTTagList();
        for (String line : lines) {
            pages.func_74742_a((NBTBase)new NBTTagString(line.replaceAll("<br>", "\n")));
        }
        contents.func_74782_a("pages", (NBTBase)pages);
        return contents;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77636_d(ItemStack stack) {
        return false;
    }
}

