/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.item.tablet;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.tslat.aoa3.client.gui.mainwindow.AdventGuiTabPlayer;
import net.tslat.aoa3.common.registration.CreativeTabsRegister;
import net.tslat.aoa3.entity.misc.tablet.EntitySoulTablet;
import net.tslat.aoa3.library.Enums;
import net.tslat.aoa3.utils.StringUtil;
import net.tslat.aoa3.utils.player.PlayerDataManager;
import net.tslat.aoa3.utils.player.PlayerUtil;

public abstract class TabletItem
extends Item {
    private final float initialSoulCost;
    private final float perTickSoulCost;
    private final int animaLevelReq;
    private final int effectRadius;

    public TabletItem(String name, String registryName, float placementCost, float tickSoulDrain, int levelReq, int effectRadius) {
        this.func_77655_b(name);
        this.setRegistryName("aoa3:" + registryName);
        this.func_77637_a(CreativeTabsRegister.TABLETS);
        this.func_77625_d(1);
        this.initialSoulCost = placementCost;
        this.perTickSoulCost = tickSoulDrain;
        this.animaLevelReq = levelReq;
        this.effectRadius = effectRadius;
    }

    public final float getSoulDrain() {
        return this.perTickSoulCost;
    }

    public int getEffectRadius() {
        return this.effectRadius;
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        IBlockState targetBlockState = world.func_180495_p(pos).func_185899_b((IBlockAccess)world, pos);
        if (facing != EnumFacing.UP || targetBlockState.func_193401_d((IBlockAccess)world, pos, EnumFacing.UP) != BlockFaceShape.SOLID) {
            return EnumActionResult.FAIL;
        }
        if (!world.field_72995_K) {
            PlayerDataManager plData = PlayerUtil.getAdventPlayer(player);
            if (player.func_184812_l_() || plData.stats().getLevel(Enums.Skills.ANIMA) >= this.animaLevelReq) {
                float soulCost = this.initialSoulCost * (1.0f - (float)(plData.stats().getLevel(Enums.Skills.ANIMA) - 1) / 200.0f) * (PlayerUtil.isWearingFullSet(player, Enums.ArmourSets.ANIMA) ? 0.5f : 1.0f);
                EntitySoulTablet tabletEntity = this.getTabletEntity(world, player);
                AxisAlignedBB blockBoundingBox = targetBlockState.func_185890_d((IBlockAccess)world, pos);
                tabletEntity.func_70080_a((float)pos.func_177958_n() + hitX, (double)pos.func_177956_o() + (blockBoundingBox == null ? 0.0 : blockBoundingBox.field_72337_e), (float)pos.func_177952_p() + hitZ, player.field_70177_z, player.field_70125_A);
                if (world.func_72917_a(tabletEntity.func_174813_aQ(), (Entity)tabletEntity) && plData.stats().consumeResource(Enums.Resources.SOUL, soulCost, false)) {
                    world.func_72838_d((Entity)tabletEntity);
                    if (!player.field_71075_bZ.field_75098_d) {
                        player.func_184586_b(hand).func_190918_g(1);
                    }
                    return EnumActionResult.SUCCESS;
                }
            } else {
                PlayerUtil.notifyPlayerOfInsufficientLevel((EntityPlayerMP)player, Enums.Skills.ANIMA, this.animaLevelReq);
            }
        }
        return EnumActionResult.PASS;
    }

    protected abstract EntitySoulTablet getTabletEntity(World var1, EntityPlayer var2);

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        tooltip.add(StringUtil.getColourLocaleStringWithArguments("items.description.skillRequirement", AdventGuiTabPlayer.getSkillLevel(Enums.Skills.ANIMA) < this.animaLevelReq ? TextFormatting.RED : TextFormatting.GREEN, String.valueOf(this.animaLevelReq), StringUtil.getLocaleString("skills.anima.name")));
        tooltip.add(StringUtil.getColourLocaleStringWithArguments("items.description.tablet.placementCost", TextFormatting.AQUA, String.valueOf(this.initialSoulCost * (1.0f - (float)(Math.min(100, AdventGuiTabPlayer.getSkillLevel(Enums.Skills.ANIMA)) - 1) / 200.0f))));
        tooltip.add(StringUtil.getColourLocaleStringWithArguments("items.description.tablet.usageCost", TextFormatting.AQUA, String.valueOf((float)((int)(this.perTickSoulCost * 2000.0f)) / 100.0f)));
        tooltip.add(StringUtil.getColourLocaleStringWithArguments("items.description.tablet.radius", TextFormatting.AQUA, String.valueOf(this.effectRadius)));
    }
}

