/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.item.tool.misc;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.tslat.aoa3.common.registration.CreativeTabsRegister;
import net.tslat.aoa3.common.registration.SoundsRegister;
import net.tslat.aoa3.entity.misc.pixon.EntityPixon;
import net.tslat.aoa3.library.Enums;
import net.tslat.aoa3.utils.ItemUtil;
import net.tslat.aoa3.utils.StringUtil;
import net.tslat.aoa3.utils.player.PlayerDataManager;
import net.tslat.aoa3.utils.player.PlayerUtil;

public class InfusionBowl
extends Item {
    private final int harvestAmount;
    private final int harvestLevelModifier;

    public InfusionBowl(String name, String registryName, int durability, int harvestAmount, int harvestLevelModifier) {
        this.func_77655_b(name);
        this.setRegistryName("aoa3:" + registryName);
        this.func_77637_a(CreativeTabsRegister.TOOLS);
        this.func_77656_e(durability);
        this.func_77625_d(1);
        this.harvestAmount = harvestAmount;
        this.harvestLevelModifier = harvestLevelModifier;
    }

    public boolean func_77616_k(ItemStack stack) {
        return false;
    }

    public int getHarvestAmount() {
        return this.harvestAmount;
    }

    public int getHarvestReqModifier() {
        return this.harvestLevelModifier;
    }

    public void handlePixonHarvest(EntityPlayer player, EntityPixon pixon, ItemStack bowlItemStack) {
        int harvestCount;
        LootTable harvestTable = player.field_70170_p.func_184146_ak().func_186521_a(pixon.getHarvestLootTable());
        ArrayList<ItemStack> harvestStacks = new ArrayList<ItemStack>();
        LootContext lootContext = new LootContext.Builder((WorldServer)player.field_70170_p).func_186470_a(player).func_186472_a((Entity)pixon).func_186471_a();
        PlayerDataManager plData = PlayerUtil.getAdventPlayer(player);
        for (harvestCount = 0; harvestCount < this.getHarvestAmount() && pixon.func_110143_aJ() > 0.0f; ++harvestCount) {
            if (!player.field_71075_bZ.field_75098_d) {
                bowlItemStack.func_77972_a(1, (EntityLivingBase)player);
            }
            harvestStacks.addAll(harvestTable.func_186462_a(player.func_70681_au(), lootContext));
            if (plData.equipment().getCurrentFullArmourSet() == Enums.ArmourSets.INFUSION) {
                harvestStacks.addAll(harvestTable.func_186462_a(player.func_70681_au(), lootContext));
            }
            pixon.func_70606_j(pixon.func_110143_aJ() - 7.0f + (float)field_77697_d.nextInt(6));
        }
        if (!harvestStacks.isEmpty()) {
            ItemUtil.givePlayerMultipleItems(player, harvestStacks);
        }
        if (pixon.field_70170_p.field_73011_w.getDimension() == 0 && pixon.field_70170_p.func_72935_r()) {
            plData.stats().addTribute(Enums.Deities.LUXON, 4 * harvestCount);
        }
        if (pixon.func_70089_S()) {
            pixon.func_70604_c((EntityLivingBase)player);
        } else {
            player.func_70074_a((EntityLivingBase)pixon);
        }
        player.func_71029_a(StatList.func_188057_b((Item)bowlItemStack.func_77973_b()));
        player.field_70170_p.func_184148_a(null, (double)pixon.func_180425_c().func_177958_n(), (double)pixon.func_180425_c().func_177956_o(), (double)pixon.func_180425_c().func_177952_p(), SoundsRegister.ENTITY_PIXON_HARVEST, SoundCategory.MASTER, 1.0f, 1.0f);
    }

    public boolean func_111207_a(ItemStack stack, EntityPlayer player, EntityLivingBase target, EnumHand hand) {
        return target instanceof EntityPixon;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        tooltip.add(StringUtil.getLocaleString("item.InfusionBowl.desc.1"));
    }
}

