/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.item.tool.pickaxe;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.tslat.aoa3.capabilities.handlers.AdventMiscStackSerializeableCapability;
import net.tslat.aoa3.capabilities.interfaces.CapabilityBaseMiscStackSerializable;
import net.tslat.aoa3.capabilities.providers.AdventMiscStackSerializeableProvider;
import net.tslat.aoa3.common.registration.MaterialsRegister;
import net.tslat.aoa3.item.tool.pickaxe.BasePickaxe;
import net.tslat.aoa3.library.Enums;
import net.tslat.aoa3.utils.ItemUtil;
import net.tslat.aoa3.utils.player.PlayerDataManager;
import net.tslat.aoa3.utils.player.PlayerUtil;

public class EnergisticPickaxe
extends BasePickaxe {
    public EnergisticPickaxe() {
        super("EnergisticPickaxe", "energistic_pickaxe", MaterialsRegister.TOOL_ENERGISTIC);
    }

    public float func_150893_a(ItemStack stack, IBlockState state) {
        float speed = super.func_150893_a(stack, state);
        if (speed != 1.0f && this.hasEnergy(stack)) {
            return speed * 3.0f;
        }
        return speed;
    }

    public boolean func_179218_a(ItemStack stack, World world, IBlockState state, BlockPos pos, EntityLivingBase entity) {
        CapabilityBaseMiscStackSerializable cap = EnergisticPickaxe.getCapability(stack);
        if (cap != null && super.func_150893_a(stack, state) != 1.0f) {
            cap.setValue(Math.max(0.0f, cap.getValue() - 5.0f));
        }
        return super.func_179218_a(stack, world, state, pos, entity);
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        CapabilityBaseMiscStackSerializable cap;
        if (!world.field_72995_K && (cap = EnergisticPickaxe.getCapability(player.func_184586_b(hand))) != null) {
            PlayerDataManager plData = PlayerUtil.getAdventPlayer(player);
            float storeAmount = MathHelper.func_76131_a((float)(2000.0f - cap.getValue()), (float)0.0f, (float)Math.min(20.0f, plData.stats().getResourceValue(Enums.Resources.ENERGY)));
            cap.setValue(cap.getValue() + storeAmount);
            plData.stats().consumeResource(Enums.Resources.ENERGY, storeAmount, true);
            return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)player.func_184586_b(hand));
        }
        return super.func_77659_a(world, player, hand);
    }

    private boolean hasEnergy(ItemStack stack) {
        CapabilityBaseMiscStackSerializable cap = EnergisticPickaxe.getCapability(stack);
        if (cap != null) {
            return cap.getValue() >= 5.0f;
        }
        return false;
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable NBTTagCompound nbt) {
        return new AdventMiscStackSerializeableProvider();
    }

    @Nullable
    public NBTTagCompound getNBTShareTag(ItemStack stack) {
        NBTTagCompound tag = super.getNBTShareTag(stack);
        if (tag == null) {
            tag = new NBTTagCompound();
        }
        tag.func_74776_a("AdventMiscStackCapability", EnergisticPickaxe.getCapability(stack).getValue());
        return tag;
    }

    public void readNBTShareTag(ItemStack stack, @Nullable NBTTagCompound nbt) {
        if (nbt != null && nbt.func_74764_b("AdventMiscStackCapability")) {
            EnergisticPickaxe.getCapability(stack).setValue(Math.min(2000.0f, nbt.func_74760_g("AdventMiscStackCapability")));
        }
        super.readNBTShareTag(stack, nbt);
    }

    public static CapabilityBaseMiscStackSerializable getCapability(ItemStack stack) {
        return (CapabilityBaseMiscStackSerializable)stack.getCapability(AdventMiscStackSerializeableProvider.MISC_STACK, null);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag flag) {
        tooltip.add(ItemUtil.getFormattedDescriptionText("item.EnergisticPickaxe.desc.1", Enums.ItemDescriptionType.POSITIVE));
        tooltip.add(ItemUtil.getFormattedDescriptionText("item.EnergisticPickaxe.desc.2", Enums.ItemDescriptionType.POSITIVE));
        AdventMiscStackSerializeableCapability cap = (AdventMiscStackSerializeableCapability)stack.getCapability(AdventMiscStackSerializeableProvider.MISC_STACK, null);
        if (cap != null) {
            tooltip.add(ItemUtil.getFormattedDescriptionText("items.description.energisticTool", Enums.ItemDescriptionType.NEUTRAL, Integer.toString((int)cap.getValue())));
        }
    }
}

