/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.item.weapon.blaster;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.tslat.aoa3.common.registration.SoundsRegister;
import net.tslat.aoa3.entity.projectiles.blaster.EntityHeavyShowerShot;
import net.tslat.aoa3.entity.projectiles.blaster.EntityShowerShot;
import net.tslat.aoa3.entity.projectiles.blaster.EntityWeightedShowerShot;
import net.tslat.aoa3.entity.projectiles.staff.BaseEnergyShot;
import net.tslat.aoa3.item.weapon.blaster.BaseBlaster;
import net.tslat.aoa3.library.Enums;
import net.tslat.aoa3.utils.ItemUtil;
import net.tslat.aoa3.utils.WorldUtil;

public class ApocoShower
extends BaseBlaster {
    public ApocoShower(double dmg, int durability, int fireDelayTicks, float energyCost) {
        super(dmg, durability, fireDelayTicks, energyCost);
        this.func_77655_b("ApocoShower");
        this.setRegistryName("aoa3:apoco_shower");
    }

    @Override
    @Nullable
    public SoundEvent getFiringSound() {
        return SoundsRegister.SPIRIT_SHOWER_FIRE;
    }

    @Override
    public void fire(ItemStack blaster, EntityLivingBase shooter) {
        shooter.field_70170_p.func_72838_d((Entity)new EntityShowerShot(shooter, this, 60));
        shooter.field_70170_p.func_72838_d((Entity)new EntityWeightedShowerShot(shooter, this, 60));
        shooter.field_70170_p.func_72838_d((Entity)new EntityHeavyShowerShot(shooter, this, 60));
    }

    @Override
    public void doBlockImpact(BaseEnergyShot shot, BlockPos block, EntityLivingBase shooter) {
        WorldUtil.createExplosion((Entity)shooter, shot.field_70170_p, (Entity)shot, 2.5f);
    }

    @Override
    protected void doImpactEffect(BaseEnergyShot shot, Entity target, EntityLivingBase shooter) {
        WorldUtil.createExplosion((Entity)shooter, shot.field_70170_p, (Entity)shot, 2.5f);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag flag) {
        tooltip.add(ItemUtil.getFormattedDescriptionText("item.SpiritShower.desc.1", Enums.ItemDescriptionType.POSITIVE));
        super.func_77624_a(stack, world, tooltip, flag);
    }
}

