/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.item.weapon.blaster;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.tslat.aoa3.common.registration.SoundsRegister;
import net.tslat.aoa3.entity.projectiles.blaster.EntityAtomizerBounce;
import net.tslat.aoa3.entity.projectiles.blaster.EntityAtomizerShot;
import net.tslat.aoa3.entity.projectiles.staff.BaseEnergyShot;
import net.tslat.aoa3.item.weapon.EnergyProjectileWeapon;
import net.tslat.aoa3.item.weapon.blaster.BaseBlaster;
import net.tslat.aoa3.library.Enums;
import net.tslat.aoa3.utils.ItemUtil;
import net.tslat.aoa3.utils.WorldUtil;

public class Atomizer
extends BaseBlaster {
    public Atomizer(double dmg, int durability, int fireDelayTicks, float energyCost) {
        super(dmg, durability, fireDelayTicks, energyCost);
        this.func_77655_b("Atomizer");
        this.setRegistryName("aoa3:atomizer");
    }

    @Override
    @Nullable
    public SoundEvent getFiringSound() {
        return SoundsRegister.ATOMIZER_FIRE;
    }

    @Override
    public void fire(ItemStack blaster, EntityLivingBase shooter) {
        shooter.field_70170_p.func_72838_d((Entity)new EntityAtomizerShot(shooter, this, 60));
    }

    @Override
    public void doBlockImpact(BaseEnergyShot shot, BlockPos block, EntityLivingBase shooter) {
        if (shot instanceof EntityAtomizerShot) {
            shot.field_70170_p.func_72838_d((Entity)new EntityAtomizerBounce(shooter, (EnergyProjectileWeapon)this, (EntityAtomizerShot)shot, field_77697_d.nextGaussian() * 0.5, 1.3, field_77697_d.nextGaussian() * 0.5));
        } else {
            WorldUtil.createExplosion((Entity)shooter, shot.field_70170_p, (Entity)shot, 1.5f);
        }
    }

    @Override
    public boolean doEntityImpact(BaseEnergyShot shot, Entity target, EntityLivingBase shooter) {
        if (super.doEntityImpact(shot, target, shooter)) {
            WorldUtil.createExplosion((Entity)shooter, shot.field_70170_p, (Entity)shot, 1.5f);
            if (shot instanceof EntityAtomizerShot) {
                shot.field_70170_p.func_72838_d((Entity)new EntityAtomizerBounce(shooter, (EnergyProjectileWeapon)this, (EntityAtomizerShot)shot, field_77697_d.nextGaussian() * 0.5, 1.3, field_77697_d.nextGaussian() * 0.5));
            }
            return true;
        }
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag flag) {
        tooltip.add(ItemUtil.getFormattedDescriptionText("item.Atomizer.desc.1", Enums.ItemDescriptionType.POSITIVE));
        super.func_77624_a(stack, world, tooltip, flag);
    }
}

