/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.item.weapon.blaster;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.tslat.aoa3.common.registration.SoundsRegister;
import net.tslat.aoa3.entity.projectiles.blaster.EntityDestroyerShot;
import net.tslat.aoa3.entity.projectiles.staff.BaseEnergyShot;
import net.tslat.aoa3.item.weapon.blaster.BaseBlaster;
import net.tslat.aoa3.library.Enums;
import net.tslat.aoa3.utils.ItemUtil;
import net.tslat.aoa3.utils.WorldUtil;

public class DarkDestroyer
extends BaseBlaster {
    public DarkDestroyer(double dmg, int durability, int fireDelayTicks, float energyCost) {
        super(dmg, durability, fireDelayTicks, energyCost);
        this.func_77655_b("DarkDestroyer");
        this.setRegistryName("aoa3:dark_destroyer");
    }

    @Override
    @Nullable
    public SoundEvent getFiringSound() {
        return SoundsRegister.DOOM_GUN_FIRE;
    }

    @Override
    public void fire(ItemStack blaster, EntityLivingBase shooter) {
        shooter.field_70170_p.func_72838_d((Entity)new EntityDestroyerShot(shooter, this, 60));
    }

    @Override
    public void doBlockImpact(BaseEnergyShot shot, BlockPos block, EntityLivingBase shooter) {
        this.doExplosions(shot, shooter, shot.field_70165_t, shot.field_70163_u, shot.field_70161_v);
    }

    @Override
    protected void doImpactEffect(BaseEnergyShot shot, Entity target, EntityLivingBase shooter) {
        this.doExplosions(shot, shooter, shot.field_70165_t, shot.field_70163_u, shot.field_70161_v);
    }

    private void doExplosions(BaseEnergyShot shot, EntityLivingBase shooter, double posX, double posY, double posZ) {
        for (double x = posX - 5.0; x <= posX + 5.0; x += 2.5) {
            for (double y = posY - 5.0; y <= posY + 5.0; y += 2.5) {
                for (double z = posZ - 5.0; z <= posZ + 5.0; z += 2.5) {
                    WorldUtil.createExplosion((Entity)shooter, shot.field_70170_p, x, y, z, 2.0f);
                }
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag flag) {
        tooltip.add(ItemUtil.getFormattedDescriptionText("item.DarkDestroyer.desc.1", Enums.ItemDescriptionType.POSITIVE));
        super.func_77624_a(stack, world, tooltip, flag);
    }
}

