/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.item.weapon.gun;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.tslat.aoa3.common.registration.EnchantmentsRegister;
import net.tslat.aoa3.common.registration.SoundsRegister;
import net.tslat.aoa3.entity.projectiles.gun.BaseBullet;
import net.tslat.aoa3.entity.projectiles.gun.EntityWartDart;
import net.tslat.aoa3.item.weapon.gun.BaseGun;
import net.tslat.aoa3.library.Enums;
import net.tslat.aoa3.utils.ItemUtil;
import net.tslat.aoa3.utils.StringUtil;

public class WartGun
extends BaseGun {
    double dmg;
    int firingDelay;

    public WartGun(double dmg, int durability, int firingDelayTicks, float recoil) {
        super(dmg, durability, firingDelayTicks, recoil);
        this.dmg = dmg;
        this.firingDelay = firingDelayTicks;
        this.func_77655_b("WartGun");
        this.setRegistryName("aoa3:wart_gun");
    }

    @Override
    @Nullable
    public SoundEvent getFiringSound() {
        return SoundsRegister.BLOWPIPE_FIRE;
    }

    @Override
    protected void doImpactEffect(Entity target, EntityLivingBase shooter, BaseBullet bullet, float bulletDmgMultiplier) {
        if (target instanceof EntityLivingBase) {
            target.func_70015_d(3);
        }
    }

    @Override
    public BaseBullet findAndConsumeAmmo(EntityPlayer player, ItemStack gunStack, EnumHand hand) {
        if (ItemUtil.findInventoryItem(player, new ItemStack(Items.field_151075_bm), true, 1 + EnchantmentHelper.func_77506_a((Enchantment)EnchantmentsRegister.GREED, (ItemStack)gunStack))) {
            return new EntityWartDart((EntityLivingBase)player, (BaseGun)gunStack.func_77973_b(), hand, 120, 0);
        }
        return null;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag flag) {
        tooltip.add(1, StringUtil.getColourLocaleStringWithArguments("items.description.damage.gun", TextFormatting.DARK_RED, Double.toString(this.dmg)));
        tooltip.add(ItemUtil.getFormattedDescriptionText("items.description.damage.fire", Enums.ItemDescriptionType.POSITIVE));
        tooltip.add(StringUtil.getLocaleStringWithArguments("items.description.gun.speed", Double.toString((double)(2000 / this.firingDelay) / 100.0)));
        tooltip.add(StringUtil.getColourLocaleStringWithArguments("items.description.ammo.other", TextFormatting.LIGHT_PURPLE, StringUtil.getLocaleString("item.netherStalkSeeds.name")));
    }
}

