/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.item.weapon.maul;

import com.google.common.collect.Multimap;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.MultiPartEntityPart;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityFireball;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;
import net.tslat.aoa3.capabilities.providers.AdventMiscStackProvider;
import net.tslat.aoa3.common.registration.CreativeTabsRegister;
import net.tslat.aoa3.common.registration.EnchantmentsRegister;
import net.tslat.aoa3.common.registration.ItemRegister;
import net.tslat.aoa3.item.weapon.AdventWeapon;
import net.tslat.aoa3.item.weapon.LongReachWeapon;
import net.tslat.aoa3.library.Enums;
import net.tslat.aoa3.library.misc.AoAAttributes;
import net.tslat.aoa3.utils.ConfigurationUtil;
import net.tslat.aoa3.utils.EntityUtil;
import net.tslat.aoa3.utils.ItemUtil;

public abstract class BaseMaul
extends Item
implements AdventWeapon,
LongReachWeapon {
    protected final float dmg;
    protected final double speed;
    protected final double knockback;
    protected final AttributeModifier REACH_MODIFIER = new AttributeModifier(UUID.fromString("678cb085-1367-42c3-8437-d07ade6201d0"), "AoAMaulReach", (double)(this.getReach() - 3.5f), 0);

    public BaseMaul(Float dmg, Double speed, double knockback, int durability) {
        this.dmg = dmg.floatValue();
        this.speed = speed;
        this.knockback = knockback;
        this.func_77637_a(CreativeTabsRegister.MAULS);
        this.func_77656_e(durability);
        this.func_77625_d(1);
        this.func_77664_n();
    }

    public float getDamage() {
        return this.dmg * (ConfigurationUtil.MainConfig.funOptions.hardcoreMode ? 1.25f : 1.0f);
    }

    public double getAttackSpeed() {
        return this.speed;
    }

    public double getBaseKnockback() {
        return this.knockback;
    }

    @Override
    public float getReach() {
        return 4.0f;
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.BLOCK;
    }

    public boolean canDestroyBlockInCreative(World world, BlockPos pos, ItemStack stack, EntityPlayer player) {
        return false;
    }

    public boolean onEntitySwing(EntityLivingBase holder, ItemStack stack) {
        return false;
    }

    public boolean canDisableShield(ItemStack stack, ItemStack shield, EntityLivingBase target, EntityLivingBase attacker) {
        return true;
    }

    public boolean func_179218_a(ItemStack stack, World world, IBlockState state, BlockPos pos, EntityLivingBase holder) {
        if (!world.field_72995_K && (double)state.func_185887_b(world, pos) != 0.0) {
            stack.func_77972_a(state.func_185904_a() == Material.field_151576_e ? 1 : 2, holder);
        }
        return true;
    }

    public boolean onLeftClickEntity(ItemStack stack, EntityPlayer player, Entity entity) {
        return true;
    }

    @Override
    public boolean attackEntity(ItemStack stack, Entity target, EntityLivingBase attacker, float dmg) {
        if (dmg < 0.0f) {
            dmg = this.getDamage() + 1.0f;
        }
        if (attacker instanceof EntityPlayer) {
            if (target instanceof EntityFireball) {
                target.func_70097_a(DamageSource.func_76365_a((EntityPlayer)((EntityPlayer)attacker)), dmg);
            } else {
                PotionEffect str = attacker.func_70660_b(MobEffects.field_76420_g);
                PotionEffect weak = attacker.func_70660_b(MobEffects.field_76437_t);
                float targetHealth = 0.0f;
                if (target instanceof EntityLivingBase) {
                    targetHealth = ((EntityLivingBase)target).func_110143_aJ();
                }
                if (str != null) {
                    dmg += (float)((str.func_76458_c() + 1) * 3);
                }
                if (weak != null) {
                    dmg -= (float)((weak.func_76458_c() + 1) * 4);
                }
                float cooldownMultiplier = ((EntityPlayer)attacker).func_184825_o(0.0f);
                float crushMod = 1.0f + 0.15f * (float)EnchantmentHelper.func_77506_a((Enchantment)EnchantmentsRegister.CRUSH, (ItemStack)stack);
                float finalDmg = dmg * cooldownMultiplier + 0.1f;
                if (target instanceof EntityDragon ? ((EntityDragon)target).func_70965_a((MultiPartEntityPart)target.func_70021_al()[0], DamageSource.func_76365_a((EntityPlayer)((EntityPlayer)attacker)), finalDmg) : target.func_70097_a(DamageSource.func_76365_a((EntityPlayer)((EntityPlayer)attacker)), finalDmg)) {
                    int hearts;
                    if (target instanceof EntityLivingBase) {
                        EntityUtil.doScaledKnockback((EntityLivingBase)target, (Entity)attacker, (float)this.knockback * crushMod * cooldownMultiplier, attacker.field_70165_t - target.field_70165_t, attacker.field_70161_v - target.field_70161_v);
                    }
                    if (attacker.field_70170_p instanceof WorldServer && target instanceof EntityLivingBase && (hearts = (int)((targetHealth - ((EntityLivingBase)target).func_110143_aJ()) / 2.0f)) > 0) {
                        ((WorldServer)attacker.field_70170_p).func_175739_a(EnumParticleTypes.DAMAGE_INDICATOR, target.field_70165_t, target.field_70163_u + (double)(target.field_70131_O * 0.5f), target.field_70161_v, hearts, 0.1, 0.0, 0.1, 0.2, new int[0]);
                    }
                    stack.func_77972_a(1, attacker);
                    this.doMeleeEffect(stack, (EntityPlayer)attacker, target, finalDmg, cooldownMultiplier);
                }
            }
        } else if (target instanceof EntityLivingBase) {
            ((EntityLivingBase)target).func_70653_a((Entity)attacker, (float)this.knockback, attacker.field_70165_t - target.field_70165_t, attacker.field_70161_v - target.field_70161_v);
        }
        return false;
    }

    protected void doMeleeEffect(ItemStack stack, EntityPlayer attacker, Entity target, float finalDmg, float attackCooldown) {
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable NBTTagCompound nbt) {
        return new AdventMiscStackProvider();
    }

    public boolean func_82789_a(ItemStack stack, ItemStack repairMaterial) {
        return repairMaterial.func_77973_b() != Items.field_151134_bR && OreDictionary.itemMatches((ItemStack)repairMaterial, (ItemStack)new ItemStack((Item)ItemRegister.MAGIC_REPAIR_DUST), (boolean)false);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77662_d() {
        return true;
    }

    public int func_77619_b() {
        return 8;
    }

    public Multimap<String, AttributeModifier> getAttributeModifiers(EntityEquipmentSlot equipmentSlot, ItemStack stack) {
        Multimap multimap = super.getAttributeModifiers(equipmentSlot, stack);
        if (equipmentSlot == EntityEquipmentSlot.MAINHAND) {
            multimap.put((Object)EntityPlayer.REACH_DISTANCE.func_111108_a(), (Object)this.REACH_MODIFIER);
            multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)AoAAttributes.vanillaWeaponDamageModifier(this.getDamage()));
            multimap.put((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)AoAAttributes.vanillaWeaponSpeedModifier(this.getAttackSpeed()));
        }
        return multimap;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        tooltip.add(ItemUtil.getFormattedDescriptionText("items.description.maul.knockback", Enums.ItemDescriptionType.ITEM_TYPE_INFO, Double.toString((double)((int)(this.knockback * 700.0)) / 100.0)));
    }
}

