/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.item.weapon.sniper;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.tslat.aoa3.common.registration.SoundsRegister;
import net.tslat.aoa3.entity.projectiles.gun.BaseBullet;
import net.tslat.aoa3.item.weapon.sniper.BaseSniper;
import net.tslat.aoa3.library.Enums;
import net.tslat.aoa3.utils.EntityUtil;
import net.tslat.aoa3.utils.ItemUtil;
import net.tslat.aoa3.utils.player.PlayerUtil;

public class HeadHunter
extends BaseSniper {
    public HeadHunter(double dmg, int durability, int firingDelayTicks, float recoil) {
        super(dmg, durability, firingDelayTicks, recoil);
        this.func_77655_b("HeadHunter");
        this.setRegistryName("aoa3:head_hunter");
    }

    @Override
    @Nullable
    public SoundEvent getFiringSound() {
        return SoundsRegister.SNIPER_FIRE;
    }

    @Override
    public Enums.ScopeScreens getScreen() {
        return Enums.ScopeScreens.DOTTED;
    }

    @Override
    protected void doImpactEffect(Entity target, EntityLivingBase shooter, BaseBullet bullet, float bulletDmgMultiplier) {
        Vec3d preciseImpactSpot;
        if (target instanceof EntityLivingBase && (preciseImpactSpot = EntityUtil.preciseEntityInterceptCalculation(target, (Entity)bullet, 20)) != null) {
            double headMinRange = target.func_174813_aQ().field_72338_b + (double)target.func_70047_e() - (double)(target.field_70131_O * 0.105f);
            double headMaxRange = headMinRange + (double)(target.field_70131_O * 0.225f);
            if (preciseImpactSpot.field_72448_b > headMinRange && preciseImpactSpot.field_72448_b < headMaxRange) {
                for (int i = 0; i < 5; ++i) {
                    ((WorldServer)target.field_70170_p).func_180505_a(EnumParticleTypes.DAMAGE_INDICATOR, true, preciseImpactSpot.field_72450_a + field_77697_d.nextDouble() - 0.5, preciseImpactSpot.field_72448_b + field_77697_d.nextDouble() - 0.5, preciseImpactSpot.field_72449_c + field_77697_d.nextDouble() - 0.5, 3, 0.0, 0.0, 0.0, 0.0, new int[0]);
                }
                if (shooter.func_184586_b(EnumHand.MAIN_HAND).func_77973_b() != this && shooter.func_184586_b(EnumHand.OFF_HAND).func_77973_b() != this) {
                    return;
                }
                if (shooter instanceof EntityPlayer) {
                    if (shooter instanceof EntityPlayerMP) {
                        PlayerUtil.playSoundForPlayer((EntityPlayerMP)shooter, SoundsRegister.FORAGING_LOOT, SoundCategory.PLAYERS, shooter.field_70165_t, shooter.field_70163_u, shooter.field_70161_v, 0.3f, 1.0f);
                    }
                    ((EntityPlayer)shooter).func_184811_cZ().func_185145_a((Item)this, (int)((float)this.getFiringDelay() / 2.0f));
                }
            }
        }
    }

    @Override
    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag flag) {
        tooltip.add(ItemUtil.getFormattedDescriptionText("item.HeadHunter.desc.1", Enums.ItemDescriptionType.POSITIVE));
        super.func_77624_a(stack, world, tooltip, flag);
    }
}

