/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.item.weapon.staff;

import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.tslat.aoa3.common.registration.ItemRegister;
import net.tslat.aoa3.common.registration.SoundsRegister;
import net.tslat.aoa3.entity.projectiles.staff.BaseEnergyShot;
import net.tslat.aoa3.entity.projectiles.staff.EntityFireflyShot;
import net.tslat.aoa3.item.misc.RuneItem;
import net.tslat.aoa3.item.weapon.staff.BaseStaff;
import net.tslat.aoa3.library.Enums;
import net.tslat.aoa3.utils.EntityUtil;
import net.tslat.aoa3.utils.ItemUtil;

public class FireflyStaff
extends BaseStaff {
    public FireflyStaff(int durability) {
        super(durability);
        this.func_77655_b("FireflyStaff");
        this.setRegistryName("aoa3:firefly_staff");
    }

    @Override
    @Nullable
    public SoundEvent getCastingSound() {
        return SoundsRegister.FIREFLY_STAFF_CAST;
    }

    @Override
    protected void populateRunes(HashMap<RuneItem, Integer> runes) {
        runes.put(ItemRegister.WIND_RUNE, 2);
        runes.put(ItemRegister.STRIKE_RUNE, 2);
        runes.put(ItemRegister.FIRE_RUNE, 1);
    }

    @Override
    public void cast(World world, ItemStack staff, EntityLivingBase caster, Object args) {
        world.func_72838_d((Entity)new EntityFireflyShot(caster, this, 60));
    }

    @Override
    public boolean doEntityImpact(BaseEnergyShot shot, Entity target, EntityLivingBase shooter) {
        if (EntityUtil.dealMagicDamage((Entity)shot, shooter, target, this.getDmg(), false)) {
            target.func_70015_d(5);
            UUID targetUUID = target.func_110124_au();
            if (targetUUID.equals(((EntityFireflyShot)shot).lastTargetUUID)) {
                return true;
            }
            for (int i = 0; i < field_77697_d.nextInt(7) + 1; ++i) {
                shot.field_70170_p.func_72838_d((Entity)new EntityFireflyShot(shooter, this, (EntityFireflyShot)shot, targetUUID, field_77697_d.nextGaussian() * 0.35, 1.4f, field_77697_d.nextGaussian() * 0.35));
            }
            return true;
        }
        return false;
    }

    @Override
    public float getDmg() {
        return 11.0f;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag flag) {
        tooltip.add(ItemUtil.getFormattedDescriptionText("item.FireflyStaff.desc.1", Enums.ItemDescriptionType.POSITIVE));
        super.func_77624_a(stack, world, tooltip, flag);
    }
}

