/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.item.weapon.staff;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.IGrowable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Items;
import net.minecraft.item.ItemDye;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.tslat.aoa3.common.registration.ItemRegister;
import net.tslat.aoa3.common.registration.SoundsRegister;
import net.tslat.aoa3.item.misc.RuneItem;
import net.tslat.aoa3.item.weapon.staff.BaseStaff;
import net.tslat.aoa3.library.Enums;
import net.tslat.aoa3.utils.ItemUtil;
import net.tslat.aoa3.utils.WorldUtil;

public class NatureStaff
extends BaseStaff {
    public NatureStaff(int durability) {
        super(durability);
        this.func_77655_b("NatureStaff");
        this.setRegistryName("aoa3:nature_staff");
    }

    @Override
    @Nullable
    public SoundEvent getCastingSound() {
        return SoundsRegister.NATURE_STAFF_CAST;
    }

    @Override
    public Object checkPreconditions(EntityLivingBase caster, ItemStack staff) {
        ArrayList<BlockPos> blocks = WorldUtil.getBlocksWithinAABB(caster.field_70170_p, caster.func_174813_aQ().func_186662_g(10.0), (state, pos) -> state.func_177230_c() instanceof IGrowable && ((IGrowable)state.func_177230_c()).func_176473_a(caster.field_70170_p, pos.func_185334_h(), state, false));
        return blocks.isEmpty() ? null : blocks;
    }

    @Override
    protected void populateRunes(HashMap<RuneItem, Integer> runes) {
        runes.put(ItemRegister.LIFE_RUNE, 4);
        runes.put(ItemRegister.ENERGY_RUNE, 2);
    }

    @Override
    public void cast(World world, ItemStack staff, EntityLivingBase caster, Object args) {
        for (BlockPos pos : (ArrayList)args) {
            ItemDye.func_179234_a((ItemStack)new ItemStack(Items.field_151100_aR, 1, 15), (World)caster.field_70170_p, (BlockPos)pos);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag flag) {
        tooltip.add(ItemUtil.getFormattedDescriptionText("item.NatureStaff.desc.1", Enums.ItemDescriptionType.POSITIVE));
        super.func_77624_a(stack, world, tooltip, flag);
    }
}

