/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.item.weapon.staff;

import java.util.HashMap;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityFireworkRocket;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.tslat.aoa3.common.registration.ItemRegister;
import net.tslat.aoa3.common.registration.SoundsRegister;
import net.tslat.aoa3.item.misc.RuneItem;
import net.tslat.aoa3.item.weapon.staff.BaseStaff;
import net.tslat.aoa3.library.Enums;
import net.tslat.aoa3.utils.ItemUtil;
import net.tslat.aoa3.utils.PredicateUtil;

public class ShowStaff
extends BaseStaff {
    public ShowStaff(int durability) {
        super(durability);
        this.func_77655_b("ShowStaff");
        this.setRegistryName("aoa3:show_staff");
    }

    @Override
    @Nullable
    public SoundEvent getCastingSound() {
        return SoundsRegister.SHOW_STAFF_CAST;
    }

    @Override
    protected void populateRunes(HashMap<RuneItem, Integer> runes) {
        runes.put(ItemRegister.COMPASS_RUNE, 3);
        runes.put(ItemRegister.POWER_RUNE, 3);
    }

    @Override
    public Object checkPreconditions(EntityLivingBase caster, ItemStack staff) {
        List list = caster.field_70170_p.func_175647_a(EntityLivingBase.class, caster.func_174813_aQ().func_186662_g(30.0), PredicateUtil.IS_HOSTILE_MOB);
        if (!list.isEmpty()) {
            return list;
        }
        return null;
    }

    @Override
    public void cast(World world, ItemStack staff, EntityLivingBase caster, Object args) {
        for (EntityLivingBase entity : (List)args) {
            entity.func_70015_d(5);
            entity.func_70690_d(new PotionEffect(MobEffects.field_188423_x, 100, 0, true, true));
            world.func_72838_d((Entity)new EntityFireworkRocket(world, entity.field_70165_t, entity.func_174813_aQ().field_72337_e, entity.field_70161_v, this.makeFireworksStack()));
        }
    }

    private ItemStack makeFireworksStack() {
        ItemStack fireworks = new ItemStack(Items.field_151152_bP, 1);
        NBTTagCompound explosionTag = new NBTTagCompound();
        NBTTagCompound fireworksTag = new NBTTagCompound();
        NBTTagCompound finalTag = new NBTTagCompound();
        NBTTagCompound wrapperTag = new NBTTagCompound();
        NBTTagList finalTagList = new NBTTagList();
        explosionTag.func_74757_a("Trail", true);
        explosionTag.func_74783_a("Colors", new int[]{0});
        explosionTag.func_74774_a("Type", (byte)4);
        fireworksTag.func_74782_a("Explosion", (NBTBase)explosionTag);
        finalTagList.func_74742_a((NBTBase)fireworksTag);
        finalTag.func_74782_a("Explosions", (NBTBase)finalTagList);
        finalTag.func_74774_a("Flight", (byte)3);
        wrapperTag.func_74782_a("Fireworks", (NBTBase)finalTag);
        fireworks.func_77982_d(wrapperTag);
        return fireworks;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag flag) {
        tooltip.add(ItemUtil.getFormattedDescriptionText("item.ShowStaff.desc.1", Enums.ItemDescriptionType.POSITIVE));
        super.func_77624_a(stack, world, tooltip, flag);
    }
}

