/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.item.weapon.sword;

import com.google.common.collect.Multimap;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.tslat.aoa3.capabilities.handlers.AdventMiscStackCapability;
import net.tslat.aoa3.capabilities.providers.AdventMiscStackProvider;
import net.tslat.aoa3.item.weapon.sword.BaseSword;
import net.tslat.aoa3.library.Enums;
import net.tslat.aoa3.utils.ItemUtil;

public class PrimalSword
extends BaseSword {
    public PrimalSword(Item.ToolMaterial material, double speed) {
        super(material, speed);
        this.func_77655_b("PrimalSword");
        this.setRegistryName("aoa3:primal_sword");
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int itemSlot, boolean isSelected) {
        AdventMiscStackCapability cap;
        if (world.func_72820_D() % 10L == 0L && entity instanceof EntityLivingBase && (cap = (AdventMiscStackCapability)stack.getCapability(AdventMiscStackProvider.MISC_STACK, null)) != null) {
            if (isSelected) {
                float currentCalcBuff;
                float currentDamageMod = cap.getValue();
                if (currentDamageMod != (currentCalcBuff = this.getCurrentDamageBuff(entity))) {
                    ((EntityLivingBase)entity).func_110140_aT().func_111148_a(this.getAttributeModifiers(EntityEquipmentSlot.MAINHAND, stack));
                    cap.setValue(currentCalcBuff);
                    ((EntityLivingBase)entity).func_110140_aT().func_111147_b(this.getAttributeModifiers(EntityEquipmentSlot.MAINHAND, stack));
                }
            } else if (cap.getValue() != 0.0f) {
                ((EntityLivingBase)entity).func_110140_aT().func_111148_a(this.getAttributeModifiers(EntityEquipmentSlot.MAINHAND, stack));
                cap.setValue(0.0f);
            }
        }
    }

    private float getCurrentDamageBuff(Entity holder) {
        if (holder instanceof EntityLivingBase) {
            float armour = (float)((EntityLivingBase)holder).func_110148_a(SharedMonsterAttributes.field_188791_g).func_111126_e();
            if (armour > 15.0f) {
                return 15.0f / armour;
            }
            return 1.5f - armour / 30.0f;
        }
        return 1.0f;
    }

    public Multimap<String, AttributeModifier> getAttributeModifiers(EntityEquipmentSlot slot, ItemStack stack) {
        AdventMiscStackCapability cap;
        Multimap<String, AttributeModifier> modifierMap = super.func_111205_h(slot);
        if (slot == EntityEquipmentSlot.MAINHAND && (cap = (AdventMiscStackCapability)stack.getCapability(AdventMiscStackProvider.MISC_STACK, null)) != null) {
            ItemUtil.setAttribute(modifierMap, SharedMonsterAttributes.field_111264_e, field_111210_e, this.getDamage() * (cap.getValue() == 0.0f ? 1.0f : cap.getValue()));
        }
        return modifierMap;
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        tooltip.add(ItemUtil.getFormattedDescriptionText("item.PrimalSword.desc.1", Enums.ItemDescriptionType.POSITIVE));
    }
}

