/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.item.weapon.sword;

import java.util.List;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.tslat.aoa3.common.registration.ItemRegister;
import net.tslat.aoa3.item.misc.RuneItem;
import net.tslat.aoa3.item.weapon.sword.BaseSword;
import net.tslat.aoa3.library.Enums;
import net.tslat.aoa3.utils.EntityUtil;
import net.tslat.aoa3.utils.ItemUtil;

public class RunicSword
extends BaseSword {
    public RunicSword(Item.ToolMaterial material, double speed) {
        super(material, speed);
        this.func_77655_b("RunicSword");
        this.setRegistryName("aoa3:runic_sword");
    }

    @Override
    protected void doMeleeEffect(ItemStack stack, EntityLivingBase target, EntityLivingBase attacker, float attackCooldown) {
        ItemStack offhandStack;
        if (!attacker.field_70170_p.field_72995_K && (double)attackCooldown > 0.75 && attacker instanceof EntityPlayer && (offhandStack = attacker.func_184592_cb()).func_77973_b() instanceof RuneItem && offhandStack.func_190916_E() >= 5) {
            RuneItem rune = (RuneItem)offhandStack.func_77973_b();
            if (rune == ItemRegister.POISON_RUNE) {
                target.func_70690_d(new PotionEffect(MobEffects.field_76436_u, 72, 1, false, true));
            } else if (rune == ItemRegister.WITHER_RUNE) {
                target.func_70690_d(new PotionEffect(MobEffects.field_82731_v, 40, 2, false, true));
            } else if (rune == ItemRegister.FIRE_RUNE) {
                target.func_70015_d(5);
            } else if (rune == ItemRegister.WIND_RUNE) {
                EntityUtil.doScaledKnockback(target, (Entity)attacker, 0.5f, attacker.field_70165_t - target.field_70165_t, attacker.field_70161_v - target.field_70161_v);
            } else if (rune == ItemRegister.WATER_RUNE) {
                target.func_70690_d(new PotionEffect(MobEffects.field_76421_d, 60, 0, false, true));
            } else if (rune == ItemRegister.CHARGED_RUNE) {
                ((WorldServer)target.field_70170_p).func_175739_a(EnumParticleTypes.VILLAGER_ANGRY, target.field_70165_t + (double)(field_77697_d.nextFloat() * target.field_70130_N * 2.0f) - (double)target.field_70130_N, target.field_70163_u + 1.0 + (double)(field_77697_d.nextFloat() * target.field_70131_O), target.field_70161_v + (double)(field_77697_d.nextFloat() * target.field_70130_N * 2.0f) - (double)target.field_70130_N, 3, 0.0, 0.0, 0.0, 0.0, new int[0]);
            } else {
                return;
            }
            offhandStack.func_190918_g(5);
            stack.func_77972_a(1, attacker);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        tooltip.add(ItemUtil.getFormattedDescriptionText("item.RunicSword.desc.1", Enums.ItemDescriptionType.POSITIVE));
        tooltip.add(ItemUtil.getFormattedDescriptionText("item.RunicSword.desc.2", Enums.ItemDescriptionType.NEGATIVE));
    }
}

