/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.item.weapon.thrown;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.tslat.aoa3.entity.projectiles.gun.BaseBullet;
import net.tslat.aoa3.item.weapon.AdventWeapon;
import net.tslat.aoa3.item.weapon.gun.BaseGun;
import net.tslat.aoa3.utils.EntityUtil;
import net.tslat.aoa3.utils.StringUtil;

public abstract class BaseThrownWeapon
extends BaseGun
implements AdventWeapon {
    double dmg;
    int firingDelay;

    public BaseThrownWeapon(double dmg, int fireDelayTicks) {
        super(dmg, 1, fireDelayTicks, 0.0f);
        this.func_77656_e(0);
        this.func_77625_d(64);
        this.dmg = dmg;
        this.firingDelay = fireDelayTicks;
    }

    @Override
    public void doImpactDamage(Entity target, EntityLivingBase shooter, BaseBullet bullet, float bulletDmgMultiplier) {
        if (target != null && this.dmg > 0.0) {
            EntityUtil.dealRangedDamage(target, shooter, (Entity)bullet, (float)this.dmg * bulletDmgMultiplier);
        }
    }

    @Override
    public BaseBullet findAndConsumeAmmo(EntityPlayer player, ItemStack gunStack, EnumHand hand) {
        return null;
    }

    public boolean func_77616_k(ItemStack stack) {
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag flag) {
        if (this.dmg > 0.0) {
            tooltip.add(1, StringUtil.getColourLocaleStringWithArguments("items.description.damage.ranged", TextFormatting.DARK_RED, Double.toString(this.dmg)));
        }
        tooltip.add(StringUtil.getColourLocaleString("items.description.thrownWeapon", TextFormatting.AQUA));
        tooltip.add(StringUtil.getLocaleStringWithArguments("items.description.throwable.speed", Double.toString((double)(2000 / this.firingDelay) / 100.0)));
    }

    @Override
    public Multimap<String, AttributeModifier> getAttributeModifiers(EntityEquipmentSlot equipmentSlot, ItemStack stack) {
        return HashMultimap.create();
    }
}

