/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.library.loot.conditions;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.util.Random;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.tslat.aoa3.library.Enums;
import net.tslat.aoa3.utils.player.PlayerUtil;

public class PlayerHasResource
implements LootCondition {
    private final Enums.Resources resource;
    private final float amount;

    public PlayerHasResource(Enums.Resources resource, float amount) {
        this.resource = resource;
        this.amount = amount;
    }

    public boolean func_186618_a(Random rand, LootContext context) {
        return context.func_186495_b() != null && PlayerUtil.getAdventPlayer((EntityPlayer)context.func_186495_b()).stats().getResourceValue(this.resource) >= this.amount;
    }

    public static class Serializer
    extends LootCondition.Serializer<PlayerHasResource> {
        public Serializer() {
            super(new ResourceLocation("aoa3", "player_has_resource"), PlayerHasResource.class);
        }

        public void serialize(JsonObject json, PlayerHasResource value, JsonSerializationContext context) {
            json.addProperty("resource", value.resource.toString().toLowerCase());
            json.addProperty("amount", (Number)Float.valueOf(value.amount));
        }

        public PlayerHasResource deserialize(JsonObject json, JsonDeserializationContext context) {
            return new PlayerHasResource(Enums.Resources.valueOf(JsonUtils.func_151200_h((JsonObject)json, (String)"resource").toUpperCase()), JsonUtils.func_151217_k((JsonObject)json, (String)"amount"));
        }
    }
}

