/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.utils;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class RenderUtil {
    public static void drawScaledCustomSizeModalRect(double x, double y, float u, float v, float uWidth, float vHeight, double width, double height, float tileWidth, float tileHeight) {
        float widthRatio = 1.0f / tileWidth;
        float heightRatio = 1.0f / tileHeight;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferbuilder.func_181662_b(x, y + height, 0.0).func_187315_a((double)(u * widthRatio), (double)((v + vHeight) * heightRatio)).func_181675_d();
        bufferbuilder.func_181662_b(x + width, y + height, 0.0).func_187315_a((double)((u + uWidth) * widthRatio), (double)((v + vHeight) * heightRatio)).func_181675_d();
        bufferbuilder.func_181662_b(x + width, y, 0.0).func_187315_a((double)((u + uWidth) * widthRatio), (double)(v * heightRatio)).func_181675_d();
        bufferbuilder.func_181662_b(x, y, 0.0).func_187315_a((double)(u * widthRatio), (double)(v * heightRatio)).func_181675_d();
        tessellator.func_78381_a();
    }

    public static void drawCenteredScaledString(FontRenderer fontRenderer, String msg, int x, int y, float scale, int colour, StringRenderType renderType) {
        float realX = ((float)x - (float)fontRenderer.func_78256_a(msg) * scale / 2.0f) / scale;
        float realY = (float)y / scale;
        GlStateManager.func_179094_E();
        GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
        if (renderType == StringRenderType.OUTLINED) {
            if (!Minecraft.func_71410_x().func_152349_b()) {
                scale = 1.0f;
            }
            fontRenderer.func_175065_a(msg, realX, realY + 1.0f / scale, 0, false);
            fontRenderer.func_175065_a(msg, realX, realY - 1.0f / scale, 0, false);
            fontRenderer.func_175065_a(msg, realX + 1.0f / scale, realY, 0, false);
            fontRenderer.func_175065_a(msg, realX - 1.0f / scale, realY, 0, false);
        }
        fontRenderer.func_175065_a(msg, realX, realY, colour, renderType == StringRenderType.DROP_SHADOW);
        GlStateManager.func_179121_F();
    }

    public static void drawScaledString(FontRenderer fontRenderer, String msg, int x, int y, float scale, int colour, StringRenderType renderType) {
        float realX = (float)x / scale;
        float realY = (float)y / scale;
        GlStateManager.func_179094_E();
        GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
        if (renderType == StringRenderType.OUTLINED) {
            if (!Minecraft.func_71410_x().func_152349_b()) {
                scale = 1.0f;
            }
            fontRenderer.func_175065_a(msg, realX, realY + 1.0f / scale, 0, false);
            fontRenderer.func_175065_a(msg, realX, realY - 1.0f / scale, 0, false);
            fontRenderer.func_175065_a(msg, realX + 1.0f / scale, realY, 0, false);
            fontRenderer.func_175065_a(msg, realX - 1.0f / scale, realY, 0, false);
        }
        fontRenderer.func_175065_a(msg, realX, realY, colour, renderType == StringRenderType.DROP_SHADOW);
        GlStateManager.func_179121_F();
    }

    public static void drawOutlinedText(FontRenderer fontRenderer, String msg, int x, int y, int colour, float currentScale) {
        if (!Minecraft.func_71410_x().func_152349_b()) {
            currentScale = 1.0f;
        }
        fontRenderer.func_175065_a(msg, (float)x, (float)y + 1.0f / currentScale, 0, false);
        fontRenderer.func_175065_a(msg, (float)x, (float)y - 1.0f / currentScale, 0, false);
        fontRenderer.func_175065_a(msg, (float)x + 1.0f / currentScale, (float)y, 0, false);
        fontRenderer.func_175065_a(msg, (float)x - 1.0f / currentScale, (float)y, 0, false);
        fontRenderer.func_175065_a(msg, (float)x, (float)y, colour, false);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static enum StringRenderType {
        NORMAL,
        DROP_SHADOW,
        OUTLINED;

    }
}

