/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.worldgen.trees;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockVine;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.tslat.aoa3.block.functional.saplings.SaplingBlock;
import net.tslat.aoa3.common.registration.BlockRegister;
import net.tslat.aoa3.worldgen.trees.WorldGenTree;

public class WorldGenCreepTree
extends WorldGenTree {
    private static final IBlockState leaves = BlockRegister.CREEP_LEAVES.func_176223_P();
    private static final IBlockState vines = BlockRegister.CREEP_VINES.func_176223_P();

    public WorldGenCreepTree(@Nullable SaplingBlock sapling) {
        super(sapling);
    }

    @Override
    public boolean func_180709_b(World world, Random rand, BlockPos pos) {
        int trunkHeight = 6 + rand.nextInt(10);
        if (!this.checkSafeHeight(world, pos, trunkHeight + 2, 1)) {
            return false;
        }
        if (!this.checkAndPrepSoil(world, pos, 1)) {
            return false;
        }
        BlockPos.MutableBlockPos movablePos = new BlockPos.MutableBlockPos(pos.func_177977_b());
        IBlockState log = BlockRegister.CREEP_LOG.func_176223_P();
        int ringLocation = 1 + rand.nextInt(trunkHeight - 3);
        if (ringLocation < trunkHeight / 2) {
            ringLocation = -1;
        }
        for (int i = 0; i < trunkHeight; ++i) {
            this.placeBlock(world, (BlockPos)movablePos.func_189536_c(EnumFacing.UP), log);
            if (i != ringLocation) continue;
            int ringWidth = 1 + rand.nextInt(2);
            for (int y = 0; y <= rand.nextInt(2); ++y) {
                for (int x = -ringWidth; x <= ringWidth; ++x) {
                    for (int z = -ringWidth; z <= ringWidth; ++z) {
                        this.placeLeafBlock(world, rand, movablePos.func_177982_a(x, y, z));
                    }
                }
            }
        }
        if (rand.nextBoolean()) {
            int width = 1 + rand.nextInt(2);
            for (int y = 0; y <= 1 + rand.nextInt(2); ++y) {
                for (int x = -width; x <= width; ++x) {
                    for (int z = -width; z <= width; ++z) {
                        this.placeLeafBlock(world, rand, movablePos.func_177982_a(x, y, z));
                    }
                }
            }
        } else {
            int z;
            int x;
            for (int y = 0; y > -rand.nextInt(3); --y) {
                for (int x2 = -2; x2 <= 2; ++x2) {
                    for (int z2 = -2; z2 <= 2; ++z2) {
                        this.placeLeafBlock(world, rand, movablePos.func_177982_a(x2, y, z2));
                    }
                }
            }
            if (rand.nextBoolean()) {
                for (x = -2; x <= 2; ++x) {
                    for (z = -2; z <= 2; ++z) {
                        if (x * x + z * z > 4) continue;
                        this.placeLeafBlock(world, rand, movablePos.func_177982_a(x, 1, z));
                    }
                }
            } else {
                for (x = -1; x <= 1; ++x) {
                    for (z = -1; z <= 1; ++z) {
                        this.placeLeafBlock(world, rand, movablePos.func_177982_a(x, 1, z));
                    }
                }
            }
        }
        return true;
    }

    private void placeLeafBlock(World world, Random rand, BlockPos leafPos) {
        this.placeBlock(world, leafPos, leaves);
        for (EnumFacing dir : EnumFacing.field_176754_o) {
            BlockPos vinePos;
            if (!(rand.nextFloat() < 0.65f) || !world.func_175623_d(vinePos = leafPos.func_177972_a(dir))) continue;
            this.placeBlock(world, vinePos, vines.func_177226_a((IProperty)BlockVine.func_176267_a((EnumFacing)dir.func_176734_d()), (Comparable)Boolean.valueOf(true)));
            if (!world.func_175623_d(vinePos.func_177977_b())) continue;
            this.placeBlock(world, vinePos.func_177977_b(), vines.func_177226_a((IProperty)BlockVine.func_176267_a((EnumFacing)dir.func_176734_d()), (Comparable)Boolean.valueOf(true)));
            if (!world.func_175623_d(vinePos.func_177979_c(2))) continue;
            this.placeBlock(world, vinePos.func_177979_c(2), vines.func_177226_a((IProperty)BlockVine.func_176267_a((EnumFacing)dir.func_176734_d()), (Comparable)Boolean.valueOf(true)));
        }
    }
}

