/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.worldgen.trees;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.tslat.aoa3.block.functional.saplings.SaplingBlock;
import net.tslat.aoa3.common.registration.BlockRegister;
import net.tslat.aoa3.worldgen.trees.WorldGenTree;

public class WorldGenInvertedAchonyTree
extends WorldGenTree {
    public WorldGenInvertedAchonyTree(@Nullable SaplingBlock sapling) {
        super(sapling);
    }

    @Override
    protected boolean checkSafeHeight(World world, BlockPos pos, int maxHeight, int trunkWidth) {
        return pos.func_177956_o() <= 256 && pos.func_177956_o() - maxHeight >= 1;
    }

    @Override
    public boolean func_180709_b(World world, Random rand, BlockPos pos) {
        int coreHeight;
        int trunkHeight = 20 + rand.nextInt(10);
        if (!this.checkSafeHeight(world, pos, trunkHeight + (int)((float)(coreHeight = 4 + rand.nextInt(3)) * 1.5f), 1)) {
            return false;
        }
        BlockPos.MutableBlockPos movablePos = new BlockPos.MutableBlockPos(pos.func_177984_a());
        IBlockState log = BlockRegister.ACHONY_LOG.func_176223_P();
        boolean lastRowRinged = false;
        for (int i = 0; i < trunkHeight; ++i) {
            this.placeBlock(world, (BlockPos)movablePos.func_189536_c(EnumFacing.DOWN), log);
            if (i >= 3 && rand.nextFloat() < 0.4f && !lastRowRinged) {
                this.buildLeafRing(world, movablePos.func_185334_h());
                lastRowRinged = true;
                continue;
            }
            lastRowRinged = false;
        }
        this.buildCrown(world, movablePos.func_185334_h(), coreHeight);
        return true;
    }

    private void buildCrown(World world, BlockPos pos, int coreHeight) {
        int x;
        IBlockState achonyLeaves = BlockRegister.ACHONY_LEAVES.func_176223_P();
        IBlockState lelyetianLeaves = BlockRegister.LELYETIAN_LEAVES.func_176223_P();
        this.buildLeafRing(world, pos.func_177981_b(1));
        for (x = -2; x <= 2; ++x) {
            for (int z = -2; z <= 2; ++z) {
                if (x == 0 && z == 0) continue;
                this.placeBlock(world, pos.func_177982_a(x, 0, z), achonyLeaves);
            }
        }
        for (x = -3; x <= 3; ++x) {
            this.placeBlock(world, pos.func_177982_a(x, -1, -3), achonyLeaves);
            this.placeBlock(world, pos.func_177982_a(x, -1, 3), achonyLeaves);
        }
        for (int z = -2; z <= 2; ++z) {
            this.placeBlock(world, pos.func_177982_a(3, -1, z), achonyLeaves);
            this.placeBlock(world, pos.func_177982_a(-3, -1, z), achonyLeaves);
        }
        this.placeBlock(world, pos.func_177982_a(3, -2, 2), achonyLeaves);
        this.placeBlock(world, pos.func_177982_a(3, -2, 3), achonyLeaves);
        this.placeBlock(world, pos.func_177982_a(3, -2, -2), achonyLeaves);
        this.placeBlock(world, pos.func_177982_a(3, -2, -3), achonyLeaves);
        this.placeBlock(world, pos.func_177982_a(-3, -2, 2), achonyLeaves);
        this.placeBlock(world, pos.func_177982_a(-3, -2, 3), achonyLeaves);
        this.placeBlock(world, pos.func_177982_a(-3, -2, -2), achonyLeaves);
        this.placeBlock(world, pos.func_177982_a(-3, -2, -3), achonyLeaves);
        this.placeBlock(world, pos.func_177982_a(2, -2, 3), achonyLeaves);
        this.placeBlock(world, pos.func_177982_a(-2, -2, 3), achonyLeaves);
        this.placeBlock(world, pos.func_177982_a(2, -2, -3), achonyLeaves);
        this.placeBlock(world, pos.func_177982_a(-2, -2, -3), achonyLeaves);
        this.placeBlock(world, pos.func_177982_a(3, -3, 3), achonyLeaves);
        this.placeBlock(world, pos.func_177982_a(-3, -3, -3), achonyLeaves);
        this.placeBlock(world, pos.func_177982_a(-3, -3, 3), achonyLeaves);
        this.placeBlock(world, pos.func_177982_a(3, -3, -3), achonyLeaves);
        for (x = -1; x <= 1; ++x) {
            for (int y = 0; y <= coreHeight; ++y) {
                for (int z = -1; z <= 1; ++z) {
                    this.placeBlock(world, pos.func_177982_a(x, -y, z), lelyetianLeaves);
                }
            }
        }
        for (int y = coreHeight; y <= (int)((double)coreHeight * 1.5); ++y) {
            this.placeBlock(world, pos.func_177982_a(0, -y, 0), lelyetianLeaves);
        }
    }

    private void buildLeafRing(World world, BlockPos pos) {
        IBlockState achonyLeaves = BlockRegister.ACHONY_LEAVES.func_176223_P();
        for (int x = -1; x <= 1; ++x) {
            for (int z = -1; z <= 1; ++z) {
                if (x == 0 && z == 0) continue;
                this.placeBlock(world, pos.func_177982_a(x, 0, z), achonyLeaves);
            }
        }
    }
}

