/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.worldgen.trees;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.tslat.aoa3.block.functional.saplings.SaplingBlock;
import net.tslat.aoa3.common.registration.BlockRegister;
import net.tslat.aoa3.worldgen.trees.WorldGenTree;

public class WorldGenIrogoldTree
extends WorldGenTree {
    public WorldGenIrogoldTree(@Nullable SaplingBlock sapling) {
        super(sapling);
    }

    @Override
    public boolean func_180709_b(World world, Random rand, BlockPos pos) {
        BlockPos multiSaplingPos = this.findMultiSaplingPosition(world, rand, pos, 2);
        if (this.sapling == null && rand.nextBoolean() || multiSaplingPos == null) {
            return this.generateTree1(world, rand, pos);
        }
        return this.generateTree2(world, rand, multiSaplingPos == null ? pos : multiSaplingPos);
    }

    private boolean generateTree1(World world, Random rand, BlockPos pos) {
        int trunkHeight = 7 + rand.nextInt(5);
        if (!this.checkSafeHeight(world, pos, trunkHeight + 2, 1)) {
            return false;
        }
        if (!this.checkAndPrepSoil(world, pos, 1)) {
            return false;
        }
        BlockPos.MutableBlockPos movablePos = new BlockPos.MutableBlockPos(pos.func_177977_b());
        IBlockState log = BlockRegister.IRO_LOG.func_176223_P();
        IBlockState leaves = BlockRegister.IROGOLD_LEAVES.func_176223_P();
        for (int i = 0; i < trunkHeight; ++i) {
            this.placeBlock(world, (BlockPos)movablePos.func_189536_c(EnumFacing.UP), log);
        }
        for (int x = -3; x <= 3; ++x) {
            for (int y = 0; y <= 2; ++y) {
                for (int z = -3; z <= 3; ++z) {
                    if (Math.abs(x) >= 4 - y - Math.abs(z) && Math.abs(z) >= 4 - y - Math.abs(x)) continue;
                    this.placeBlock(world, movablePos.func_177982_a(x, y, z), leaves);
                }
            }
        }
        this.placeBlock(world, movablePos.func_177982_a(0, -1, 1), leaves);
        this.placeBlock(world, movablePos.func_177982_a(0, -1, -1), leaves);
        this.placeBlock(world, movablePos.func_177982_a(1, -1, 0), leaves);
        this.placeBlock(world, movablePos.func_177982_a(-1, -1, 0), leaves);
        return true;
    }

    private boolean generateTree2(World world, Random rand, BlockPos pos) {
        int trunkHeight = 7 + rand.nextInt(5);
        if (!this.checkSafeHeight(world, pos, trunkHeight + 2, 2)) {
            return false;
        }
        if (!this.checkAndPrepSoil(world, pos, 2)) {
            return false;
        }
        IBlockState log = BlockRegister.IRO_LOG.func_176223_P();
        IBlockState leaves = BlockRegister.IROGOLD_LEAVES.func_176223_P();
        for (int i = 0; i < trunkHeight; ++i) {
            for (int x = 0; x <= 1; ++x) {
                for (int z = 0; z <= 1; ++z) {
                    this.placeBlock(world, pos.func_177982_a(x, i, z), log);
                }
            }
        }
        pos = pos.func_177981_b(trunkHeight - 1);
        int branchWidth = 2 + rand.nextInt(3);
        for (int i = branchWidth - 1; i <= branchWidth; ++i) {
            for (int j = -1; j <= 1; j += 2) {
                int i2 = (j < 0 ? i - 1 : i) * j;
                this.placeBlock(world, pos.func_177982_a(i2, 0, 0), log);
                this.placeBlock(world, pos.func_177982_a(i2, 0, 1), log);
                this.placeBlock(world, pos.func_177982_a(0, 0, i2), log);
                this.placeBlock(world, pos.func_177982_a(1, 0, i2), log);
                if (i != branchWidth) continue;
                for (EnumFacing dir : EnumFacing.field_82609_l) {
                    BlockPos leafPos = pos.func_177972_a(dir);
                    this.placeBlock(world, leafPos.func_177982_a(i2, 0, 0), leaves);
                    this.placeBlock(world, leafPos.func_177982_a(i2, 0, 1), leaves);
                    this.placeBlock(world, leafPos.func_177982_a(0, 0, i2), leaves);
                    this.placeBlock(world, leafPos.func_177982_a(1, 0, i2), leaves);
                }
            }
        }
        return true;
    }
}

