/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.worldgen.trees;

import java.util.ArrayList;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.common.IPlantable;
import net.tslat.aoa3.block.functional.saplings.SaplingBlock;
import org.apache.commons.lang3.tuple.Triple;

public abstract class WorldGenTree
extends WorldGenerator {
    protected final SaplingBlock sapling;

    public WorldGenTree(@Nullable SaplingBlock sapling) {
        super(sapling != null);
        this.sapling = sapling;
    }

    public abstract boolean func_180709_b(World var1, Random var2, BlockPos var3);

    protected void placeBlock(World world, BlockPos pos, IBlockState state, boolean overwriteBlocks) {
        if (!overwriteBlocks && !WorldGenTree.isSafeBlock(world, pos)) {
            return;
        }
        this.func_175903_a(world, pos, state);
    }

    protected void placeBlock(World world, BlockPos pos, IBlockState state) {
        this.placeBlock(world, pos, state, false);
    }

    protected static boolean isSafeBlock(World world, BlockPos pos) {
        IBlockState existingState = world.func_180495_p(pos);
        Block existingBlock = existingState.func_177230_c();
        return existingBlock.isAir(existingState, (IBlockAccess)world, pos) || existingBlock.func_176200_f((IBlockAccess)world, pos) || existingBlock.isLeaves(existingState, (IBlockAccess)world, pos);
    }

    protected boolean checkSafeHeight(World world, BlockPos pos, int maxHeight, int trunkWidth) {
        if (pos.func_177956_o() >= 1 && pos.func_177956_o() + maxHeight < 256) {
            if (this.sapling == null) {
                return true;
            }
            for (int i = 1; i <= maxHeight; ++i) {
                for (int x = 0; x < trunkWidth; ++x) {
                    for (int z = 0; z < trunkWidth; ++z) {
                        if (WorldGenTree.isSafeBlock(world, pos.func_177982_a(x, i, z))) continue;
                        return false;
                    }
                }
            }
            return true;
        }
        return false;
    }

    protected boolean checkAndPrepSoil(World world, BlockPos pos, int trunkWidth) {
        if (this.sapling == null) {
            return true;
        }
        ArrayList<Triple> soils = new ArrayList<Triple>(trunkWidth * trunkWidth);
        for (int x = 0; x < trunkWidth; ++x) {
            for (int z = 0; z < trunkWidth; ++z) {
                BlockPos soilPos = pos.func_177982_a(x, -1, z);
                IBlockState soilState = world.func_180495_p(soilPos);
                Block soil = soilState.func_177230_c();
                if (soil.isAir(soilState, (IBlockAccess)world, soilPos.func_177984_a()) || !soil.canSustainPlant(soilState, (IBlockAccess)world, soilPos, EnumFacing.UP, (IPlantable)this.sapling)) {
                    return false;
                }
                soils.add(Triple.of((Object)soilState, (Object)soil, (Object)soilPos));
            }
        }
        for (Triple soil : soils) {
            ((Block)soil.getMiddle()).onPlantGrow((IBlockState)soil.getLeft(), world, (BlockPos)soil.getRight(), ((BlockPos)soil.getRight()).func_177984_a());
            world.func_180501_a(((BlockPos)soil.getRight()).func_177984_a(), Blocks.field_150350_a.func_176223_P(), 2);
        }
        return true;
    }

    @Nullable
    protected BlockPos findMultiSaplingPosition(World world, Random rand, BlockPos pos, int size) {
        if (this.sapling == null) {
            return pos;
        }
        for (int x = 0; x >= -(size - 1); --x) {
            block1: for (int z = 0; z >= -(size - 1); --z) {
                BlockPos checkPos = pos;
                for (int i = 0; i < size; ++i) {
                    for (int j = 0; j < size; ++j) {
                        checkPos = pos.func_177982_a(x + i, 0, z + j);
                        if (world.func_180495_p(checkPos).func_177230_c() != this.sapling) continue block1;
                    }
                }
                return checkPos.func_177982_a(-size + 1, 0, -size + 1);
            }
        }
        return null;
    }
}

