/*
 * Decompiled with CFR 0.152.
 */
package lumien.randomthings.block;

import java.awt.Color;
import lumien.randomthings.block.BlockContainerBase;
import lumien.randomthings.item.ModItems;
import lumien.randomthings.lib.IRTBlockColor;
import lumien.randomthings.tileentity.TileEntityBiomeRadar;
import lumien.randomthings.util.WorldUtil;
import lumien.randomthings.util.client.RenderUtils;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockBiomeRadar
extends BlockContainerBase
implements IRTBlockColor {
    protected BlockBiomeRadar() {
        super("biomeRadar", Material.field_151573_f);
        this.func_149711_c(5.0f);
    }

    @Override
    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileEntityBiomeRadar();
    }

    @Override
    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        TileEntityBiomeRadar radar = (TileEntityBiomeRadar)worldIn.func_175625_s(pos);
        if (!radar.getCurrentCrystal().func_190926_b()) {
            WorldUtil.spawnItemStack(worldIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), radar.getCurrentCrystal());
        }
        super.func_180663_b(worldIn, pos, state);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public int colorMultiplier(IBlockState state, IBlockAccess worldIn, BlockPos pos, int renderPass) {
        if (pos == null) {
            return Color.WHITE.getRGB();
        }
        return new Color(RenderUtils.getBiomeColor(worldIn, worldIn.func_180494_b(pos), pos)).brighter().getRGB();
    }

    @Override
    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block neighborBlock, BlockPos changedPos) {
        TileEntity te = worldIn.func_175625_s(pos);
        if (te instanceof TileEntityBiomeRadar) {
            ((TileEntityBiomeRadar)te).neighborChanged(neighborBlock);
        }
    }

    public boolean isSideSolid(IBlockState base_state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return true;
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemStack equipped = playerIn.func_184614_ca();
        TileEntityBiomeRadar biomeRadar = (TileEntityBiomeRadar)worldIn.func_175625_s(pos);
        if (biomeRadar.getState() == TileEntityBiomeRadar.STATE.IDLE) {
            ItemStack currentCrystal;
            if (biomeRadar.getCurrentCrystal().func_190926_b()) {
                if (!equipped.func_190926_b() && equipped.func_77973_b() == ModItems.biomeCrystal) {
                    if (!worldIn.field_72995_K) {
                        biomeRadar.setCrystal(equipped.func_77946_l());
                        equipped.func_190918_g(1);
                        worldIn.func_180498_a(null, 1037, pos, 0);
                    }
                    return true;
                }
            } else if (equipped.func_190926_b() && !(currentCrystal = biomeRadar.getCurrentCrystal()).func_190926_b()) {
                if (!worldIn.field_72995_K) {
                    playerIn.field_71071_by.func_70299_a(playerIn.field_71071_by.field_70461_c, currentCrystal);
                    biomeRadar.setCrystal(ItemStack.field_190927_a);
                    worldIn.func_180498_a(null, 1036, pos, 0);
                }
                return true;
            }
        } else if (biomeRadar.getState() == TileEntityBiomeRadar.STATE.FINISHED && !equipped.func_190926_b() && equipped.func_77973_b() == Items.field_151121_aF) {
            if (!worldIn.field_72995_K) {
                ItemStack positionFilter = biomeRadar.generatePositionFilter();
                equipped.func_190918_g(1);
                playerIn.field_71071_by.func_70441_a(positionFilter);
            }
            return true;
        }
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }
}

