/*
 * Decompiled with CFR 0.152.
 */
package com.trforcex.mods.wallpapercraft;

import com.trforcex.mods.wallpapercraft.ModConfig;
import com.trforcex.mods.wallpapercraft.compatibility.ChiselCompatibility;
import com.trforcex.mods.wallpapercraft.compatibility.OreDictCompatibility;
import com.trforcex.mods.wallpapercraft.crafting.DynamicRecipes;
import com.trforcex.mods.wallpapercraft.crafting.ModRecipes;
import com.trforcex.mods.wallpapercraft.crafting.PasteCombinationRecipe;
import com.trforcex.mods.wallpapercraft.proxy.IProxy;
import com.trforcex.mods.wallpapercraft.util.DebugCommand;
import com.trforcex.mods.wallpapercraft.util.Logger;
import com.trforcex.mods.wallpapercraft.util.ModDataManager;
import com.trforcex.mods.wallpapercraft.util.RecipeHelper;
import net.minecraft.command.ICommand;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod(modid="wallpapercraft", name="WallpaperCraft", version="1.0.1-alpha", useMetadata=true, updateJSON="https://dl.dropboxusercontent.com/s/edouros9o00gyui/wpcraft_update.json?dl=0", acceptedMinecraftVersions="[1.12.2]")
@Mod.EventBusSubscriber
public class ModClass {
    public static org.apache.logging.log4j.Logger logger;
    @Mod.Instance
    public static ModClass instance;
    @SidedProxy(clientSide="com.trforcex.mods.wallpapercraft.proxy.ClientProxy", serverSide="com.trforcex.mods.wallpapercraft.proxy.ServerProxy")
    private static IProxy proxy;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        logger = event.getModLog();
        proxy.preInit();
        ModConfig.update();
        Logger.logDebug("preInit() \u0432\u0402\u201c done");
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        if (ModConfig.compatibility.registerVanillaWoolAndPlanksToOredict) {
            OreDictCompatibility.registerVanillaToOredict();
        }
        OreDictCompatibility.registerModBlocksToOredict();
        Logger.logDebug("OreDict \u0432\u0402\u201c done");
        proxy.init();
        Logger.logDebug("init() \u0432\u0402\u201c done");
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        if (ModConfig.compatibility.enableChiselCompatibility && Loader.isModLoaded((String)"chisel")) {
            ChiselCompatibility.init();
        }
        proxy.postInit();
        Logger.logDebug("postInit() \u0432\u0402\u201c done");
    }

    @Mod.EventHandler
    public void serverStarting(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new DebugCommand());
        Logger.logDebug("Registered debug command");
    }

    @SubscribeEvent
    public static void registerRecipes(RegistryEvent.Register<IRecipe> event) {
        ModClass.initRecipes(event);
    }

    private static void initRecipes(RegistryEvent.Register<IRecipe> event) {
        event.getRegistry().register((IForgeRegistryEntry)PasteCombinationRecipe.INSTANCE);
        Logger.logDebug("Paste combination recipe registered");
        ModClass.registerColoredPasteRecipes();
        Logger.logDebug("Colored paste recipes registered");
        ModRecipes.init();
        DynamicRecipes.init();
        Logger.logDebug("Done registering mod recipes");
    }

    private static void registerColoredPasteRecipes() {
        ResourceLocation coloredPasteGroup = RecipeHelper.getModResLoc("colored_paste");
        for (String color : ModDataManager.COLORS) {
            ResourceLocation recipeResLoc = RecipeHelper.getModResLoc("colored_paste" + color);
            String dyeOreDict = "dye" + String.valueOf(color.charAt(0)).toUpperCase() + color.substring(1);
            ItemStack pasteStack = RecipeHelper.getColoredPasteStack(color);
            RecipeHelper.addRecipe(recipeResLoc, coloredPasteGroup, pasteStack, Items.field_151119_aD, dyeOreDict);
        }
        Logger.logDebug("Done registering recipes for colored paste");
    }
}

