/*
 * Decompiled with CFR 0.152.
 */
package com.trforcex.mods.wallpapercraft;

import com.trforcex.mods.wallpapercraft.util.Logger;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Config(modid="wallpapercraft", name="wallpapercraft")
@Mod.EventBusSubscriber
public class ModConfig {
    @Config.Name(value="Compatibility")
    @Config.LangKey(value="config.wallpapercraft.compatibility")
    @Config.Comment(value={"Compatibility related settings"})
    public static Compatibility compatibility = new Compatibility();
    @Config.Name(value="Crafting")
    @Config.LangKey(value="config.wallpapercraft.crafting")
    @Config.Comment(value={"Crafting related settings"})
    public static Crafting crafting = new Crafting();
    @Config.Name(value="Debug")
    @Config.LangKey(value="config.wallpapercraft.debug")
    @Config.Comment(value={"Debugging related settings"})
    public static Debug debug = new Debug();
    @Config.Name(value="Enable tooltip hints")
    @Config.LangKey(value="config.wallpapercraft.tooltip_hints")
    @Config.Comment(value={"Enable tooltip hints for mod blocks"})
    public static boolean enableTooltipHints = true;

    @SubscribeEvent
    public static void onConfigChanged(ConfigChangedEvent event) {
        if (event.getModID().equals("wallpapercraft")) {
            ModConfig.update();
        }
    }

    public static void update() {
        ConfigManager.sync((String)"wallpapercraft", (Config.Type)Config.Type.INSTANCE);
        Logger.setMaxLogLevel(ModConfig.debug.loggingLevel);
        Logger.setUseInfoInsteadOfDebug(ModConfig.debug.redirectDebugToInfoLogFile);
    }

    public static class Debug {
        @Config.Name(value="Logging level")
        @Config.LangKey(value="config.wallpapercraft.logging_level")
        @Config.Comment(value={"0 - disable logging; 1 - 'debug' level; 2 - 'verbose' level"})
        @Config.RangeInt(min=0, max=2)
        public int loggingLevel = 0;
        @Config.Name(value="Redirect debug to latest.log file")
        @Config.LangKey(value="config.wallpapercraft.redirect_logs")
        @Config.Comment(value={""})
        public boolean redirectDebugToInfoLogFile = false;
    }

    public static class Crafting {
        @Config.Name(value="Max Colored Paste uses")
        @Config.LangKey(value="config.wallpapercraft.paste")
        @Config.Comment(value={"Determines how many times a piece colored paste can be used before it disappears"})
        @Config.RangeInt(min=1)
        @Config.RequiresMcRestart
        public int maxColoredPasteUsages = 64;
        @Config.Name(value="Max pattern presses uses")
        @Config.LangKey(value="config.wallpapercraft.presses")
        @Config.Comment(value={"Determines how many times a pattern press can be used before it breaks.", "Set to '0' to disable durability"})
        @Config.RangeInt(min=0, max=32766)
        @Config.RequiresMcRestart
        public int maxPatternPressUses = 0;
    }

    public static class Compatibility {
        @Config.Name(value="Enable Chisel compatibility")
        @Config.LangKey(value="config.wallpapercraft.chisel")
        @Config.Comment(value={"Enable this to initialize Chisel compatibility"})
        @Config.RequiresMcRestart
        public boolean enableChiselCompatibility = true;
        @Config.Name(value="Register vanilla blocks to OreDictionary")
        @Config.LangKey(value="config.wallpapercraft.oredict")
        @Config.Comment(value={"Enable this to register vanilla wool and wood planks to OreDictionary, if they aren't already registered to it"})
        @Config.RequiresMcRestart
        public boolean registerVanillaWoolAndPlanksToOredict = true;
        @Config.Name(value="Enable Forestry wood planks scrolling")
        @Config.LangKey(value="config.wallpapercraft.planks_scrolling")
        @Config.Comment(value={"Enable this to make Forestry wood planks scrollable"})
        public boolean enableForestryWoodPlanksScrolling = false;
    }
}

