/*
 * Decompiled with CFR 0.152.
 */
package com.trforcex.mods.wallpapercraft.blocks.base;

import com.trforcex.mods.wallpapercraft.blocks.base.IHasMetaItemBlock;
import com.trforcex.mods.wallpapercraft.blocks.base.ScrollingType;
import com.trforcex.mods.wallpapercraft.init.ModBlocks;
import com.trforcex.mods.wallpapercraft.init.ModCreativeTab;
import com.trforcex.mods.wallpapercraft.items.MetaItemBlock;
import com.trforcex.mods.wallpapercraft.util.ForestryDataManager;
import com.trforcex.mods.wallpapercraft.util.ModDataManager;
import com.trforcex.mods.wallpapercraft.util.ModHelper;
import java.util.Arrays;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import org.apache.commons.lang3.Validate;

public abstract class BaseModBlock
extends Block
implements IHasMetaItemBlock {
    private final MetaItemBlock itemBlock;
    private final String pattern;
    private final Block baseBlock;
    private final String color;

    public String getPattern() {
        return this.pattern;
    }

    public Block getBaseBlock() {
        return this.baseBlock;
    }

    public String getColor() {
        return this.color;
    }

    BaseModBlock(Material materialIn, float hardness, float resistance, String registryName) {
        super(materialIn);
        this.func_149711_c(hardness);
        this.func_149752_b(resistance);
        this.setRegistryName(registryName);
        this.func_149663_c(ModHelper.makeUnlocalizedName(this));
        this.func_149647_a(ModCreativeTab.WPC_TAB);
        this.itemBlock = new MetaItemBlock(this);
        String[] parts = this.getRegistryName().func_110623_a().split("_");
        this.pattern = parts.length != 1 ? String.join((CharSequence)"_", Arrays.copyOfRange(parts, 0, parts.length - 1)) : parts[0];
        this.color = parts.length != 1 && this.getScrollingType() != ScrollingType.ForestryCompatible ? parts[parts.length - 1] : (parts.length != 1 && this.getScrollingType() == ScrollingType.ForestryCompatible ? "f/c" : "j/s");
        this.baseBlock = this.pattern.contains("carpet") ? null : ModDataManager.BASE_BLOCK.get(this.pattern);
        Validate.notNull((Object)this.pattern, (String)("Pattern for [" + registryName + "] is null!"), (Object[])new Object[0]);
        Validate.notNull((Object)this.color, (String)("Color for [" + registryName + "] is null!"), (Object[])new Object[0]);
        if (!this.pattern.contains("carpet")) {
            Validate.notNull((Object)this.baseBlock, (String)("Base block for [" + registryName + "] is null!"), (Object[])new Object[0]);
        }
        ModBlocks.BLOCKS.add(this);
    }

    public ScrollingType getScrollingType() {
        String name = this.getRegistryName().func_110623_a();
        for (String pattern : ForestryDataManager.PATTERNS) {
            if (!name.contains(pattern)) continue;
            return ScrollingType.ForestryCompatible;
        }
        return ScrollingType.Scrollable;
    }

    @Override
    public MetaItemBlock getItemBlock() {
        return this.itemBlock;
    }
}

