/*
 * Decompiled with CFR 0.152.
 */
package com.trforcex.mods.wallpapercraft.compatibility;

import com.trforcex.mods.wallpapercraft.blocks.base.BaseModBlock;
import com.trforcex.mods.wallpapercraft.init.ModBlocks;
import com.trforcex.mods.wallpapercraft.util.ModUtils;
import com.trforcex.mods.wallpapercraft.util.RecipeHelper;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import org.apache.commons.lang3.Validate;
import team.chisel.api.carving.CarvingUtils;
import team.chisel.api.carving.ICarvingGroup;
import team.chisel.api.carving.ICarvingRegistry;
import team.chisel.api.carving.ICarvingVariation;

public class ChiselCompatibility {
    private static final String[] PATTERNS = new String[]{"bricks", "stone_bricks", "colored_bricks", "dotted", "diagonally_dotted", "rippled", "striped", "damask", "floral", "fancy_tiles", "clay", "wool", "checkered_wool", "wool_carpet", "checkered_carpet", "wood_planks", "stone_lamp", "aura_lamp", "tinted_glass", "textured_glass", "frosted_glass", "solid"};
    private static ICarvingRegistry chisel;

    public static void init() {
        chisel = CarvingUtils.getChiselRegistry();
        Validate.notNull((Object)chisel, (String)"Carving registry mustn't be null at this point!", (Object[])new Object[0]);
        ChiselCompatibility.registerPatterns();
    }

    private static void registerPatterns() {
        for (Block modBlock : ModBlocks.BLOCKS) {
            if (!(modBlock instanceof BaseModBlock)) continue;
            BaseModBlock block = (BaseModBlock)modBlock;
            ICarvingGroup group = chisel.getGroup(ModUtils.composeString(block.getPattern(), block.getColor())) == null ? CarvingUtils.getDefaultGroupFor((String)ModUtils.composeString(block.getPattern(), block.getColor())) : chisel.getGroup(ModUtils.composeString(block.getPattern(), block.getColor()));
            for (int meta = 0; meta <= block.getMaxMeta(); ++meta) {
                ItemStack stack = RecipeHelper.getStack(block, 1, meta);
                ICarvingVariation variation = CarvingUtils.variationFor((ItemStack)stack, (int)meta);
                chisel.addVariation(group.getName(), variation);
            }
        }
    }
}

