/*
 * Decompiled with CFR 0.152.
 */
package com.trforcex.mods.wallpapercraft.crafting;

import com.trforcex.mods.wallpapercraft.blocks.base.BaseModBlock;
import com.trforcex.mods.wallpapercraft.blocks.base.ScrollingType;
import com.trforcex.mods.wallpapercraft.init.ModBlocks;
import com.trforcex.mods.wallpapercraft.items.PressItems;
import com.trforcex.mods.wallpapercraft.util.Logger;
import com.trforcex.mods.wallpapercraft.util.ModDataManager;
import com.trforcex.mods.wallpapercraft.util.RecipeHelper;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;

public class DynamicRecipes {
    public static void init() {
        Logger.logDebug("Initializing \"dynamic\" recipes");
        for (Block block : ModBlocks.BLOCKS) {
            if (!(block instanceof BaseModBlock)) continue;
            BaseModBlock modBlock = (BaseModBlock)block;
            DynamicRecipes.registerScrollingRecipeFor(modBlock);
            DynamicRecipes.registerRecolorRecipesFor(modBlock);
            if (block.getRegistryName().func_110623_a().contains("carpet")) continue;
            DynamicRecipes.registerPatternRemovalRecipeFor(modBlock);
        }
        Logger.logDebug("Done initializing \"dynamic\" recipes");
    }

    private static void registerScrollingRecipeFor(BaseModBlock block) {
        block9: {
            block10: {
                block8: {
                    Logger.logVerbose("Registering scrolling recipe for: [" + block.getRegistryName() + "]");
                    if (block.getScrollingType() != ScrollingType.Scrollable) break block8;
                    for (int meta = 0; meta <= block.getMaxMeta(); ++meta) {
                        if (block.getPattern().equals("solid")) {
                            Logger.stubMethod();
                        }
                        ResourceLocation resLoc = RecipeHelper.getModResLoc(block.getPattern(), block.getColor(), "scrolling", String.valueOf(meta));
                        ItemStack inputStack = new ItemStack((Block)block, 1, meta);
                        ItemStack outputStack = meta < block.getMaxMeta() ? new ItemStack((Block)block, 1, meta + 1) : new ItemStack((Block)block, 1, 0);
                        RecipeHelper.addRecipe(resLoc, null, outputStack, inputStack);
                    }
                    break block9;
                }
                if (!block.getRegistryName().func_110623_a().endsWith("_1")) break block10;
                for (int meta = 0; meta <= block.getMaxMeta(); ++meta) {
                    ItemStack outputStack;
                    ResourceLocation resLoc = RecipeHelper.getModResLoc(block.getPattern(), "scrolling_1", String.valueOf(meta));
                    ItemStack inputStack = new ItemStack((Block)block, 1, meta);
                    if (meta < block.getMaxMeta()) {
                        outputStack = new ItemStack((Block)block, 1, meta + 1);
                    } else {
                        BaseModBlock outBlock = (BaseModBlock)RecipeHelper.getModBlock(block.getPattern(), "2");
                        outputStack = new ItemStack((Block)outBlock, 1, 0);
                    }
                    RecipeHelper.addRecipe(resLoc, null, outputStack, inputStack);
                }
                break block9;
            }
            if (!block.getRegistryName().func_110623_a().endsWith("_2")) break block9;
            for (int meta = 0; meta <= block.getMaxMeta(); ++meta) {
                ItemStack outputStack;
                ResourceLocation resLoc = RecipeHelper.getModResLoc(block.getPattern(), "scrolling_2", String.valueOf(meta));
                ItemStack inputStack = new ItemStack((Block)block, 1, meta);
                if (meta < block.getMaxMeta()) {
                    outputStack = new ItemStack((Block)block, 1, meta + 1);
                } else {
                    BaseModBlock outBlock = (BaseModBlock)RecipeHelper.getModBlock(block.getPattern(), "1");
                    outputStack = new ItemStack((Block)outBlock, 1, 0);
                }
                RecipeHelper.addRecipe(resLoc, null, outputStack, inputStack);
            }
        }
    }

    private static void registerRecolorRecipesFor(BaseModBlock block) {
        Logger.logVerbose("Registering recolor recipes for [" + block.getRegistryName() + "]");
        if (!block.getColor().equals("f/c")) {
            for (String color : ModDataManager.COLORS) {
                if (color.equals(block.getColor())) {
                    Logger.logVerbose("Recoloring in the same color, skipping");
                    continue;
                }
                if (!block.getColor().equals("j/s")) {
                    for (int meta = 0; meta <= block.getMaxMeta(); ++meta) {
                        if (block.getPattern().equals("jewel") || block.getPattern().equals("stamp")) {
                            Logger.stubMethod();
                        }
                        ResourceLocation resLoc = RecipeHelper.getModResLoc(block.getPattern(), block.getColor(), String.valueOf(meta), "recolor", color);
                        ItemStack inputStack = new ItemStack((Block)block, 1, meta);
                        ItemStack pasteStack = RecipeHelper.getColoredPasteStack(color);
                        BaseModBlock outputBlock = (BaseModBlock)RecipeHelper.getModBlock(block.getPattern(), color);
                        int newMeta = MathHelper.func_76125_a((int)meta, (int)0, (int)outputBlock.getMaxMeta());
                        ItemStack outputStack = new ItemStack((Block)outputBlock, 1, newMeta);
                        RecipeHelper.addRecipe(resLoc, null, outputStack, inputStack, pasteStack);
                    }
                    continue;
                }
                Logger.logVerbose("Recoloring for jewel or stamp, skipping");
            }
        } else {
            Logger.logVerbose("Forestry block found, skipping");
        }
    }

    private static void registerPatternRemovalRecipeFor(BaseModBlock block) {
        Logger.logVerbose("Registering pattern removal recipe for [" + block.getRegistryName() + "]");
        ResourceLocation resLoc = RecipeHelper.getModResLoc(block.getPattern(), block.getColor(), "removal");
        ItemStack outputStack = new ItemStack(block.getBaseBlock(), 1, 0);
        RecipeHelper.addRecipe(resLoc, null, outputStack, new Object[]{block, PressItems.itemPressRemoval});
    }
}

