/*
 * Decompiled with CFR 0.152.
 */
package com.trforcex.mods.wallpapercraft.crafting;

import com.trforcex.mods.wallpapercraft.blocks.base.BaseModBlock;
import com.trforcex.mods.wallpapercraft.init.ModBlocks;
import com.trforcex.mods.wallpapercraft.items.BasePressItem;
import com.trforcex.mods.wallpapercraft.util.Logger;
import com.trforcex.mods.wallpapercraft.util.ModDataManager;
import com.trforcex.mods.wallpapercraft.util.RecipeHelper;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.GameRegistry;

public class ModRecipes {
    public static void init() {
        Logger.logDebug("Registering general recipes");
        for (Block block : ModBlocks.BLOCKS) {
            BaseModBlock modBlock;
            if (!(block instanceof BaseModBlock)) continue;
            if (!((BaseModBlock)block).getPattern().contains("carpet")) {
                modBlock = (BaseModBlock)block;
                ModRecipes.registerRecipeForModBlock(modBlock);
                continue;
            }
            modBlock = (BaseModBlock)block;
            ModRecipes.registerRecipeForCarpet(modBlock);
        }
        Logger.logDebug("Done registering general recipes");
    }

    private static void registerRecipeForCarpet(BaseModBlock modBlock) {
        ResourceLocation recipeResLoc = modBlock.getRegistryName();
        ResourceLocation group = RecipeHelper.getModResLoc(modBlock.getPattern());
        ItemStack outputStack = new ItemStack((Block)modBlock, 1, 0);
        Block woolBlock = modBlock.getPattern().equals("checkered_wool") ? RecipeHelper.getModBlock("checkered_wool", modBlock.getColor()) : RecipeHelper.getModBlock("wool", modBlock.getColor());
        GameRegistry.addShapedRecipe((ResourceLocation)recipeResLoc, (ResourceLocation)group, (ItemStack)outputStack, (Object[])new Object[]{"WW", Character.valueOf('W'), woolBlock});
    }

    private static void registerRecipeForModBlock(BaseModBlock modBlock) {
        Logger.logVerbose("Registering recipe for [" + modBlock.getRegistryName() + "]");
        String resPath = modBlock.getRegistryName().func_110623_a();
        if ("jewel".equals(resPath) || "stamp".equals(resPath)) {
            ModRecipes.registerRecipeForJewelOrStamp(modBlock);
            return;
        }
        BasePressItem pressItem = RecipeHelper.getPressFor(modBlock);
        ItemStack outputStack = RecipeHelper.getStack(modBlock, 1, 0);
        String color = modBlock.getColor();
        String pattern = modBlock.getPattern();
        Block baseBlock = modBlock.getBaseBlock();
        String oreName = RecipeHelper.getOreName(baseBlock);
        ItemStack pasteStack = RecipeHelper.getColoredPasteStack(color);
        ResourceLocation recipeResLoc = modBlock.getRegistryName();
        ResourceLocation group = RecipeHelper.getModResLoc(pattern);
        if (!oreName.isEmpty()) {
            RecipeHelper.addRecipe(recipeResLoc, group, outputStack, new Object[]{pressItem, pasteStack, oreName});
        } else {
            RecipeHelper.addRecipe(recipeResLoc, group, outputStack, new Object[]{pressItem, pasteStack, baseBlock});
        }
    }

    private static void registerRecipeForJewelOrStamp(BaseModBlock jewelOrStampBlock) {
        BasePressItem pressItem = RecipeHelper.getPressFor(jewelOrStampBlock);
        String pattern = jewelOrStampBlock.getPattern();
        Block baseBlock = jewelOrStampBlock.getBaseBlock();
        String oreName = RecipeHelper.getOreName(baseBlock);
        for (int i = 0; i < ModDataManager.COLORS.size(); ++i) {
            String color = ModDataManager.COLORS.get(i);
            int stackMeta = ModDataManager.JEWEL_STAMP_LOOKUP[i];
            ItemStack outputStack = RecipeHelper.getStack(jewelOrStampBlock, 1, stackMeta);
            ResourceLocation jewelRecipeResLoc = RecipeHelper.getModResLoc("jewel", color);
            ResourceLocation stampRecipeResLoc = RecipeHelper.getModResLoc("stamp", color);
            ItemStack pasteStack = RecipeHelper.getColoredPasteStack(color);
            if ("jewel".equals(pattern)) {
                if (!oreName.isEmpty()) {
                    RecipeHelper.addRecipe(jewelRecipeResLoc, null, outputStack, new Object[]{pressItem, pasteStack, oreName});
                    continue;
                }
                RecipeHelper.addRecipe(jewelRecipeResLoc, null, outputStack, new Object[]{pressItem, pasteStack, baseBlock});
                continue;
            }
            if ("stamp".equals(pattern)) {
                if (!oreName.isEmpty()) {
                    RecipeHelper.addRecipe(stampRecipeResLoc, null, outputStack, new Object[]{pressItem, pasteStack, oreName});
                    continue;
                }
                RecipeHelper.addRecipe(stampRecipeResLoc, null, outputStack, new Object[]{pressItem, pasteStack, baseBlock});
                continue;
            }
            throw new IllegalArgumentException("jewelOrStampBlock is not block of jewel or stamp pattern");
        }
    }
}

