/*
 * Decompiled with CFR 0.152.
 */
package com.trforcex.mods.wallpapercraft.util;

import com.trforcex.mods.wallpapercraft.blocks.base.ModBlockForestry;
import com.trforcex.mods.wallpapercraft.blocks.base.ModBlockTypeA;
import com.trforcex.mods.wallpapercraft.blocks.base.ModBlockTypeB;
import com.trforcex.mods.wallpapercraft.blocks.base.ModBlockTypeC;
import com.trforcex.mods.wallpapercraft.init.ModBlocks;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockFactory {
    public static ModBlockTypeA createSolidBlockTypeA(String registryName) {
        return new ModBlockTypeA(Material.field_151576_e, 2.0f, 6.0f, registryName);
    }

    public static ModBlockTypeB createSolidBlockTypeB(String registryName) {
        return new ModBlockTypeB(Material.field_151576_e, 2.0f, 6.0f, registryName);
    }

    public static ModBlockTypeC createSolidBlockTypeC(String registryName) {
        return new ModBlockTypeC(Material.field_151576_e, 2.0f, 6.0f, registryName);
    }

    public static ModBlockTypeA createLampTypeA(String registryName) {
        return new ModBlockTypeA(Material.field_151592_s, 1.0f, 1.5f, registryName){
            {
                this.func_149715_a(1.0f);
            }

            public boolean func_149730_j(IBlockState state) {
                return false;
            }
        };
    }

    public static ModBlockTypeB createLampTypeB(String registryName) {
        return new ModBlockTypeB(Material.field_151592_s, 1.0f, 1.5f, registryName){
            {
                this.func_149715_a(1.0f);
            }

            public boolean func_149730_j(IBlockState state) {
                return false;
            }
        };
    }

    public static ModBlockTypeA createGlassBlockTypeA(String registryName) {
        return new ModBlockTypeA(Material.field_151592_s, 0.3f, 1.5f, registryName){
            {
                this.func_149672_a(SoundType.field_185853_f);
            }

            public BlockRenderLayer func_180664_k() {
                return BlockRenderLayer.TRANSLUCENT;
            }

            public boolean func_149686_d(IBlockState state) {
                return false;
            }

            public boolean func_149662_c(IBlockState state) {
                return false;
            }

            public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
                IBlockState iblockstate = blockAccess.func_180495_p(pos.func_177972_a(side));
                Block block = iblockstate.func_177230_c();
                if (blockState != iblockstate) {
                    return true;
                }
                if (block == this) {
                    return false;
                }
                return block != this && super.func_176225_a(blockState, blockAccess, pos, side);
            }

            protected boolean func_149700_E() {
                return true;
            }

            public int func_149745_a(Random random) {
                return 0;
            }

            public boolean canPlaceTorchOnTop(IBlockState state, IBlockAccess world, BlockPos pos) {
                return false;
            }
        };
    }

    public static ModBlockTypeB createGlassBlockTypeB(String registryName) {
        return new ModBlockTypeB(Material.field_151592_s, 0.3f, 1.5f, registryName){
            {
                this.func_149672_a(SoundType.field_185853_f);
            }

            public BlockRenderLayer func_180664_k() {
                return BlockRenderLayer.TRANSLUCENT;
            }

            public boolean func_149686_d(IBlockState state) {
                return false;
            }

            public boolean func_149662_c(IBlockState state) {
                return false;
            }

            public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
                IBlockState iblockstate = blockAccess.func_180495_p(pos.func_177972_a(side));
                Block block = iblockstate.func_177230_c();
                if (blockState != iblockstate) {
                    return true;
                }
                if (block == this) {
                    return false;
                }
                return block != this && super.func_176225_a(blockState, blockAccess, pos, side);
            }

            protected boolean func_149700_E() {
                return true;
            }

            public int func_149745_a(Random random) {
                return 0;
            }

            public boolean canPlaceTorchOnTop(IBlockState state, IBlockAccess world, BlockPos pos) {
                return false;
            }
        };
    }

    public static ModBlockTypeA createWoolBlockTypeA(String registryName) {
        return new ModBlockTypeA(Material.field_151580_n, 0.8f, 4.0f, registryName){
            {
                this.func_149672_a(SoundType.field_185854_g);
                Blocks.field_150480_ab.func_180686_a((Block)this, 30, 60);
            }
        };
    }

    public static ModBlockTypeB createWoolBlockTypeB(String registryName) {
        return new ModBlockTypeB(Material.field_151580_n, 0.8f, 4.0f, registryName){
            {
                this.func_149672_a(SoundType.field_185854_g);
                Blocks.field_150480_ab.func_180686_a((Block)this, 30, 60);
            }
        };
    }

    public static ModBlockTypeA createPlanksBlockTypeA(String registryName) {
        return new ModBlockTypeA(Material.field_151575_d, 2.0f, 15.0f, registryName){
            {
                this.func_149672_a(SoundType.field_185848_a);
                Blocks.field_150480_ab.func_180686_a((Block)this, 5, 20);
            }
        };
    }

    public static ModBlockTypeB createPlanksBlockTypeB(String registryName) {
        return new ModBlockTypeB(Material.field_151575_d, 2.0f, 15.0f, registryName){
            {
                this.func_149672_a(SoundType.field_185848_a);
                Blocks.field_150480_ab.func_180686_a((Block)this, 5, 20);
            }
        };
    }

    public static ModBlockTypeA createCarpetBlockTypeA(String registryName) {
        return new ModBlockTypeA(Material.field_151593_r, 0.1f, 0.5f, registryName){
            private final AxisAlignedBB CARPET_AABB;
            {
                this.func_149672_a(SoundType.field_185854_g);
                this.CARPET_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.0625, 1.0);
            }

            public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
                return this.CARPET_AABB;
            }

            public boolean canPlaceTorchOnTop(IBlockState state, IBlockAccess world, BlockPos pos) {
                return false;
            }

            public boolean func_149686_d(IBlockState state) {
                return false;
            }

            private boolean canBlockStay(World worldIn, BlockPos pos) {
                return !worldIn.func_175623_d(pos.func_177977_b());
            }

            public boolean func_176196_c(World worldIn, BlockPos pos) {
                return super.func_176196_c(worldIn, pos) && this.canBlockStay(worldIn, pos);
            }

            private boolean checkForDrop(World worldIn, BlockPos pos, IBlockState state) {
                if (!this.canBlockStay(worldIn, pos)) {
                    this.func_176226_b(worldIn, pos, state, 0);
                    worldIn.func_175698_g(pos);
                    return false;
                }
                return true;
            }

            public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
                this.checkForDrop(worldIn, pos, state);
            }

            public boolean func_149662_c(IBlockState state) {
                return false;
            }

            @Nonnull
            @SideOnly(value=Side.CLIENT)
            public BlockRenderLayer func_180664_k() {
                return BlockRenderLayer.CUTOUT_MIPPED;
            }

            @SideOnly(value=Side.CLIENT)
            public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
                return side == EnumFacing.UP || blockAccess.func_180495_p(pos.func_177972_a(side)).func_177230_c() == this || super.func_176225_a(blockState, blockAccess, pos, side);
            }

            public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
                return face == EnumFacing.DOWN ? BlockFaceShape.SOLID : BlockFaceShape.UNDEFINED;
            }
        };
    }

    public static ModBlockTypeB createCarpetBlockTypeB(String registryName) {
        return new ModBlockTypeB(Material.field_151593_r, 0.1f, 0.5f, registryName){
            private final AxisAlignedBB CARPET_AABB;
            {
                this.func_149672_a(SoundType.field_185854_g);
                this.CARPET_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.0625, 1.0);
            }

            public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
                return this.CARPET_AABB;
            }

            public boolean canPlaceTorchOnTop(IBlockState state, IBlockAccess world, BlockPos pos) {
                return false;
            }

            public boolean func_149686_d(IBlockState state) {
                return false;
            }

            private boolean canBlockStay(World worldIn, BlockPos pos) {
                return !worldIn.func_175623_d(pos.func_177977_b());
            }

            public boolean func_176196_c(World worldIn, BlockPos pos) {
                return super.func_176196_c(worldIn, pos) && this.canBlockStay(worldIn, pos);
            }

            private boolean checkForDrop(World worldIn, BlockPos pos, IBlockState state) {
                if (!this.canBlockStay(worldIn, pos)) {
                    this.func_176226_b(worldIn, pos, state, 0);
                    worldIn.func_175698_g(pos);
                    return false;
                }
                return true;
            }

            public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
                this.checkForDrop(worldIn, pos, state);
            }

            public boolean func_149662_c(IBlockState state) {
                return false;
            }

            @Nonnull
            @SideOnly(value=Side.CLIENT)
            public BlockRenderLayer func_180664_k() {
                return BlockRenderLayer.CUTOUT_MIPPED;
            }

            @SideOnly(value=Side.CLIENT)
            public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
                return side == EnumFacing.UP || blockAccess.func_180495_p(pos.func_177972_a(side)).func_177230_c() == this || super.func_176225_a(blockState, blockAccess, pos, side);
            }

            public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
                return face == EnumFacing.DOWN ? BlockFaceShape.SOLID : BlockFaceShape.UNDEFINED;
            }
        };
    }

    public static ModBlockTypeC createForestryWoolBlock(String registryName) {
        return new ModBlockTypeC(Material.field_151580_n, 0.8f, 4.0f, registryName){
            {
                this.func_149672_a(SoundType.field_185854_g);
                Blocks.field_150480_ab.func_180686_a((Block)this, 30, 60);
                ModBlocks.OREDICT_INIT.put(new ItemStack((Block)this, 1, Short.MAX_VALUE), "wool");
            }
        };
    }

    public static ModBlockForestry createForestryWoolBlock2(String registryName) {
        return new ModBlockForestry(Material.field_151580_n, 0.8f, 4.0f, registryName){
            {
                this.func_149672_a(SoundType.field_185854_g);
                Blocks.field_150480_ab.func_180686_a((Block)this, 30, 60);
                ModBlocks.OREDICT_INIT.put(new ItemStack((Block)this, 1, Short.MAX_VALUE), "wool");
            }
        };
    }

    public static ModBlockForestry createForestrySolidBlock2(String registryName) {
        return new ModBlockForestry(Material.field_151576_e, 2.0f, 6.0f, registryName);
    }

    public static ModBlockTypeC createForestryGlassBlock(String registryName) {
        return new ModBlockTypeC(Material.field_151592_s, 0.3f, 1.5f, registryName){
            {
                this.func_149672_a(SoundType.field_185853_f);
            }

            public BlockRenderLayer func_180664_k() {
                return BlockRenderLayer.TRANSLUCENT;
            }

            public boolean func_149686_d(IBlockState state) {
                return false;
            }

            public boolean func_149662_c(IBlockState state) {
                return false;
            }

            public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
                IBlockState iblockstate = blockAccess.func_180495_p(pos.func_177972_a(side));
                Block block = iblockstate.func_177230_c();
                if (blockState != iblockstate) {
                    return true;
                }
                if (block == this) {
                    return false;
                }
                return block != this && super.func_176225_a(blockState, blockAccess, pos, side);
            }

            protected boolean func_149700_E() {
                return true;
            }

            public int func_149745_a(Random random) {
                return 0;
            }

            public boolean canPlaceTorchOnTop(IBlockState state, IBlockAccess world, BlockPos pos) {
                return false;
            }
        };
    }

    public static ModBlockForestry createForestryGlassBlock2(String registryName) {
        return new ModBlockForestry(Material.field_151592_s, 0.3f, 1.5f, registryName){
            {
                this.func_149672_a(SoundType.field_185853_f);
            }

            public BlockRenderLayer func_180664_k() {
                return BlockRenderLayer.TRANSLUCENT;
            }

            public boolean func_149686_d(IBlockState state) {
                return false;
            }

            public boolean func_149662_c(IBlockState state) {
                return false;
            }

            public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
                IBlockState iblockstate = blockAccess.func_180495_p(pos.func_177972_a(side));
                Block block = iblockstate.func_177230_c();
                if (blockState != iblockstate) {
                    return true;
                }
                if (block == this) {
                    return false;
                }
                return block != this && super.func_176225_a(blockState, blockAccess, pos, side);
            }

            protected boolean func_149700_E() {
                return true;
            }

            public int func_149745_a(Random random) {
                return 0;
            }

            public boolean canPlaceTorchOnTop(IBlockState state, IBlockAccess world, BlockPos pos) {
                return false;
            }
        };
    }

    public static ModBlockTypeC createBeehiveLantern(String registryName) {
        return new ModBlockTypeC(Material.field_151576_e, 2.0f, 6.0f, registryName){
            {
                this.func_149715_a(0.53f);
            }
        };
    }

    public static ModBlockForestry createBeehiveLantern2(String registryName) {
        return new ModBlockForestry(Material.field_151576_e, 2.0f, 6.0f, registryName){
            {
                this.func_149715_a(0.53f);
            }
        };
    }
}

