/*
 * Decompiled with CFR 0.152.
 */
package com.trforcex.mods.wallpapercraft.util;

import com.trforcex.mods.wallpapercraft.blocks.base.BaseModBlock;
import com.trforcex.mods.wallpapercraft.init.ModItems;
import com.trforcex.mods.wallpapercraft.items.BasePressItem;
import com.trforcex.mods.wallpapercraft.util.ModDataManager;
import com.trforcex.mods.wallpapercraft.util.ModUtils;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.OreIngredient;
import org.apache.commons.lang3.Validate;

public class RecipeHelper {
    public static BasePressItem getPressFor(BaseModBlock modBlock) {
        BasePressItem item = modBlock.getPattern().equals("forestry_stone_bricks") ? (BasePressItem)ForgeRegistries.ITEMS.getValue(RecipeHelper.getModResLoc("press_stone_bricks")) : (BasePressItem)ForgeRegistries.ITEMS.getValue(RecipeHelper.getModResLoc("press", modBlock.getPattern()));
        Validate.notNull((Object)((Object)item), (String)("Press for [" + RecipeHelper.getModResLoc("press", modBlock.getPattern()) + "] is null!"), (Object[])new Object[0]);
        return item;
    }

    public static ResourceLocation getModResLoc(String ... params) {
        return new ResourceLocation("wallpapercraft", ModUtils.composeString(params));
    }

    public static void addRecipe(ResourceLocation name, ResourceLocation group, ItemStack output, Object ... ingredients) {
        Validate.noNullElements((Object[])ingredients);
        Ingredient[] arrIngredients = new Ingredient[ingredients.length];
        for (int i = 0; i < ingredients.length; ++i) {
            arrIngredients[i] = RecipeHelper.getIngredientFrom(ingredients[i]);
        }
        RecipeHelper.validate(output);
        for (Ingredient ingredient : arrIngredients) {
            if (!ingredient.equals(Ingredient.field_193370_a)) continue;
            throw new NullPointerException("Ingredient [" + ingredient + "] is empty, but is not supposed to be");
        }
        GameRegistry.addShapelessRecipe((ResourceLocation)name, (ResourceLocation)group, (ItemStack)output, (Ingredient[])arrIngredients);
    }

    private static Ingredient getIngredientFrom(Object obj) {
        if (obj instanceof Item) {
            return Ingredient.func_193367_a((Item)((Item)obj));
        }
        if (obj instanceof ItemStack) {
            return Ingredient.func_193369_a((ItemStack[])new ItemStack[]{(ItemStack)obj});
        }
        if (obj instanceof Block) {
            return Ingredient.func_193369_a((ItemStack[])new ItemStack[]{new ItemStack((Block)obj, 1, Short.MAX_VALUE)});
        }
        if (obj instanceof String) {
            return new OreIngredient((String)obj);
        }
        if (obj instanceof Ingredient) {
            return (Ingredient)obj;
        }
        throw new IllegalArgumentException("Unknown type of ingredient: [" + obj.getClass().getName() + "]");
    }

    private static Item getModItem(String ... params) {
        return RecipeHelper.getModItem(RecipeHelper.getModResLoc(params));
    }

    private static Item getModItem(ResourceLocation registryName) {
        Item item = (Item)ForgeRegistries.ITEMS.getValue(registryName);
        Validate.notNull((Object)item, (String)("Item [" + registryName + "] is null, but is not supposed to be"), (Object[])new Object[0]);
        return item;
    }

    public static Block getModBlock(String ... params) {
        return RecipeHelper.getModBlock(RecipeHelper.getModResLoc(params));
    }

    private static Block getModBlock(ResourceLocation registryName) {
        Block block = (Block)ForgeRegistries.BLOCKS.getValue(registryName);
        Validate.notNull((Object)block, (String)("Block [" + registryName + "] is null, but is not supposed to be"), (Object[])new Object[0]);
        return block;
    }

    public static ItemStack getStack(Object obj, int amount, int meta) {
        return RecipeHelper.getStack(obj, amount, meta, null);
    }

    public static ItemStack getStack(Object obj, int amount, int meta, @Nullable NBTTagCompound tagCompound) {
        if (obj instanceof Block) {
            ItemStack returnStack = new ItemStack((Block)obj, amount, meta);
            if (tagCompound != null) {
                returnStack.func_77982_d(tagCompound);
            }
            RecipeHelper.validate(returnStack);
            return returnStack;
        }
        if (obj instanceof Item) {
            ItemStack returnStack = new ItemStack((Item)obj, amount, meta);
            if (tagCompound != null) {
                returnStack.func_77982_d(tagCompound);
            }
            RecipeHelper.validate(returnStack);
            return returnStack;
        }
        if (obj instanceof String) {
            Item stackItem = RecipeHelper.getModItem((String)obj);
            ItemStack returnStack = new ItemStack(stackItem, amount, meta);
            if (tagCompound != null) {
                returnStack.func_77982_d(tagCompound);
            }
            RecipeHelper.validate(returnStack);
            return returnStack;
        }
        if (obj instanceof ResourceLocation) {
            Item stackItem = (Item)ForgeRegistries.ITEMS.getValue((ResourceLocation)obj);
            ItemStack returnStack = new ItemStack(stackItem, amount, meta);
            if (tagCompound != null) {
                returnStack.func_77982_d(tagCompound);
            }
            RecipeHelper.validate(returnStack);
            return returnStack;
        }
        throw new IllegalArgumentException("Unknown type of object: [" + obj.getClass().getName() + "]");
    }

    private static void validate(ItemStack stack) {
        if (stack == null || stack.func_190926_b()) {
            throw new IllegalArgumentException("ItemStack : x" + stack.func_190916_E() + " of " + stack.func_82833_r() + ", meta:" + stack.func_77960_j() + "is empty, but is not supposed to be");
        }
    }

    public static String getOreName(Block baseBlock) {
        if (baseBlock == Blocks.field_150405_ch) {
            return "hardenedClay";
        }
        if (baseBlock == Blocks.field_150359_w) {
            return "blockGlass";
        }
        if (baseBlock == Blocks.field_150348_b) {
            return "stone";
        }
        if (baseBlock == Blocks.field_150325_L) {
            return "blockWool";
        }
        if (baseBlock == Blocks.field_150344_f) {
            return "plankWood";
        }
        return "";
    }

    public static ItemStack getColoredPasteStack(String color) {
        return RecipeHelper.getColoredPasteStack(color, 1);
    }

    private static ItemStack getColoredPasteStack(String color, int count) {
        ItemStack stack = new ItemStack((Item)ModItems.itemColoredPaste, count, ModDataManager.COLORS.indexOf(color));
        RecipeHelper.validate(stack);
        return stack;
    }

    public static Block recolorBlock(BaseModBlock block, ItemStack pasteStack) {
        String pasteColor = ModDataManager.COLORS.get(pasteStack.func_77960_j());
        String[] parts = block.getRegistryName().func_110623_a().split("_");
        parts[parts.length - 1] = pasteColor;
        return RecipeHelper.getModBlock(parts);
    }

    private static class WrongIngredientsException
    extends RuntimeException {
        private WrongIngredientsException() {
        }
    }
}

