/*
 * Decompiled with CFR 0.152.
 */
package com.matez.wildnature.blocks;

import com.matez.wildnature.Main;
import com.matez.wildnature.init.ModBlocks;
import com.matez.wildnature.init.ModItems;
import com.matez.wildnature.util.IHasModel;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class RockBase
extends Block
implements IHasModel {
    private int type;
    Item drop = null;

    public RockBase(String name, Material material, CreativeTabs tab, int type) {
        super(material);
        this.func_149663_c(name);
        this.setRegistryName(name);
        this.func_149647_a(tab);
        this.func_149672_a(this.getPerfectSoundForMaterial(material));
        this.func_149711_c(1.0f);
        this.type = type;
        ModBlocks.BLOCKS.add(this);
        ModItems.ITEMS.add((Item)new ItemBlock((Block)this).setRegistryName(this.getRegistryName()));
        ModBlocks.ROCKS.add(this);
    }

    public RockBase(String name, Material material, CreativeTabs tab, int type, Item drop) {
        super(material);
        this.func_149663_c(name);
        this.setRegistryName(name);
        this.func_149647_a(tab);
        this.func_149672_a(this.getPerfectSoundForMaterial(material));
        this.func_149711_c(1.0f);
        this.type = type;
        this.drop = drop;
        ModBlocks.BLOCKS.add(this);
        ModItems.ITEMS.add((Item)new ItemBlock((Block)this).setRegistryName(this.getRegistryName()));
        ModBlocks.ROCKS.add(this);
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        if (this.drop == null) {
            return Item.func_150898_a((Block)Blocks.field_150347_e);
        }
        return this.drop;
    }

    public int getType() {
        return this.type;
    }

    public int getMinYByType(World world) {
        int defaultMinY = Math.round(world.func_181545_F() / 3);
        if (this.type == 0) {
            return 0;
        }
        if (this.type == 1) {
            return defaultMinY + defaultMinY + 5;
        }
        if (this.type == 2) {
            return defaultMinY + 5;
        }
        if (this.type == 3) {
            return 5;
        }
        return 0;
    }

    public int getMaxYByType(World world) {
        int defaultMaxY = Math.round(world.func_181545_F() / 3);
        if (this.type == 0) {
            return world.func_72800_K();
        }
        if (this.type == 1) {
            return world.func_181545_F();
        }
        if (this.type == 2) {
            return defaultMaxY + defaultMaxY + 5;
        }
        if (this.type == 3) {
            return defaultMaxY + 5;
        }
        return 0;
    }

    @Override
    public void registerModels() {
        Main.proxy.registerItemRenderer(Item.func_150898_a((Block)this), 0, "inventory");
    }

    public SoundType getPerfectSoundForMaterial(Material material) {
        if (material == Material.field_151573_f) {
            return SoundType.field_185852_e;
        }
        if (material == Material.field_151577_b) {
            return SoundType.field_185850_c;
        }
        if (material == Material.field_151575_d) {
            return SoundType.field_185848_a;
        }
        if (material == Material.field_151595_p) {
            return SoundType.field_185855_h;
        }
        return SoundType.field_185851_d;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.SOLID;
    }
}

