/*
 * Decompiled with CFR 0.152.
 */
package com.matez.wildnature.entity.AI;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.pathfinding.PathNavigateFlying;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.world.biome.Biome;

public class EntityAIForesterFollowPlayer
extends EntityAIBase {
    private final EntityLiving entity;
    private EntityLivingBase followingEntity;
    private double speedModifier;
    private int timeToRecalcPath;
    private final int stopDistance;
    private float oldWaterCost;
    private final int areaSize;
    private final ArrayList<Biome> followingBiomes;

    public EntityAIForesterFollowPlayer(EntityLiving entity, double speedModifier, int stopDistance, int followArea, Biome ... followOnBiomes) {
        this.entity = entity;
        this.speedModifier = speedModifier;
        this.stopDistance = stopDistance;
        this.areaSize = followArea;
        this.followingBiomes = followOnBiomes == null ? new ArrayList() : new ArrayList<Biome>(Arrays.asList(followOnBiomes));
        this.func_75248_a(3);
        if (!(entity.func_70661_as() instanceof PathNavigateGround) && !(entity.func_70661_as() instanceof PathNavigateFlying)) {
            throw new IllegalArgumentException("Unsupported mob type for FollowMobGoal");
        }
    }

    public EntityLivingBase getFollowingEntity() {
        return this.followingEntity;
    }

    public boolean func_75250_a() {
        List entities = this.entity.func_130014_f_().field_73010_i;
        for (int x = 0; x < entities.size(); ++x) {
            double distance;
            EntityPlayer entityliving = (EntityPlayer)entities.get(x);
            if (entityliving.func_184812_l_() || entityliving.func_175149_v() || entityliving.func_82150_aj() || !this.canFollowOnBiome((EntityLivingBase)entityliving) || !((distance = (double)this.entity.func_70032_d((Entity)entityliving)) > (double)this.stopDistance) || !(distance <= (double)this.areaSize)) continue;
            this.followingEntity = entityliving;
            return true;
        }
        return false;
    }

    public boolean canFollowOnBiome(EntityLivingBase entity) {
        if (this.followingBiomes == null || this.followingBiomes.isEmpty()) {
            return true;
        }
        for (int x = 0; x < this.followingBiomes.size(); ++x) {
            if (entity.func_130014_f_().func_180494_b(entity.func_180425_c()) != this.followingBiomes.get(x)) continue;
            return true;
        }
        return false;
    }

    public boolean func_75253_b() {
        if (this.followingEntity == null) {
            return this.func_75250_a();
        }
        List entities = this.entity.func_130014_f_().field_73010_i;
        for (int x = 0; x < entities.size(); ++x) {
            EntityPlayer entityliving = (EntityPlayer)entities.get(x);
            if (entityliving.func_184812_l_() || entityliving.func_175149_v() || entityliving.func_82150_aj() || !this.canFollowOnBiome((EntityLivingBase)entityliving)) continue;
            return true;
        }
        return this.func_75250_a();
    }

    public void func_75249_e() {
        this.timeToRecalcPath = 0;
        this.oldWaterCost = this.entity.func_184643_a(PathNodeType.WATER);
        this.entity.func_184644_a(PathNodeType.WATER, 0.1f);
    }

    public void func_75251_c() {
        this.entity.func_70095_a(false);
        this.entity.func_70031_b(false);
        this.followingEntity = null;
        this.entity.func_70661_as().func_75499_g();
        this.entity.func_184644_a(PathNodeType.WATER, this.oldWaterCost);
    }

    public void func_75246_d() {
        if (this.followingEntity != null) {
            boolean sprint = false;
            this.entity.func_70671_ap().func_75651_a((Entity)this.followingEntity, 10.0f, (float)this.entity.func_70646_bf());
            double distance = this.entity.func_70032_d((Entity)this.followingEntity);
            if (--this.timeToRecalcPath <= 0) {
                this.timeToRecalcPath = 10;
            }
            if (distance > (double)this.stopDistance && distance < (double)this.areaSize) {
                this.entity.func_70661_as().func_75499_g();
                if (distance > (double)(this.stopDistance * 2)) {
                    this.speedModifier += this.speedModifier * 0.5;
                    sprint = true;
                }
                boolean bl = this.entity.func_70661_as().func_75497_a((Entity)this.followingEntity, this.speedModifier);
            } else {
                this.entity.func_70661_as().func_75499_g();
            }
            this.entity.func_70095_a(!this.entity.func_70661_as().func_75500_f() && !sprint);
            this.entity.func_70031_b(!this.entity.func_70661_as().func_75500_f() && sprint);
        }
    }
}

