/*
 * Decompiled with CFR 0.152.
 */
package com.matez.wildnature.worldgen;

import com.google.common.collect.Lists;
import com.matez.wildnature.Main;
import com.matez.wildnature.blocks.LeavesBase;
import com.matez.wildnature.init.ModBlocks;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.BlockLog;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import net.minecraftforge.common.IPlantable;

public class treeGen_eucalyptus
extends WorldGenAbstractTree {
    private Random rand;
    private World world;
    private BlockPos basePos = BlockPos.field_177992_a;
    int heightLimit = 15;
    int height = 12;
    double heightAttenuation = 0.618;
    double branchSlope = 0.581;
    double scaleWidth = 1.0;
    double leafDensity = 0.6;
    int trunkSize = 1;
    int heightLimitLimit = 13;
    int leafDistanceLimit = 6;
    List<FoliageCoordinates> foliageCoords;
    private static final IBlockState LOG = ModBlocks.EUCALYPTUS_LOG.func_176223_P();
    private static final IBlockState LEAVES = ModBlocks.EUCALYPTUS_LEAVES.func_176223_P().func_177226_a((IProperty)LeavesBase.field_176236_b, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)LeavesBase.field_176237_a, (Comparable)Boolean.valueOf(false));

    public treeGen_eucalyptus(boolean notify) {
        super(notify);
    }

    void generateLeafNodeList() {
        int k;
        int i;
        this.height = (int)((double)this.heightLimit * this.heightAttenuation);
        if (this.height >= this.heightLimit) {
            this.height = this.heightLimit - 1;
        }
        if ((i = (int)(1.382 + Math.pow(this.leafDensity * (double)this.heightLimit / 13.0, 2.0))) < 1) {
            i = 1;
        }
        int j = this.basePos.func_177956_o() + this.height;
        this.foliageCoords = Lists.newArrayList();
        this.foliageCoords.add(new FoliageCoordinates(this.basePos.func_177981_b(k), j));
        for (k = this.heightLimit - this.leafDistanceLimit; k >= 0; --k) {
            float f = this.layerSize(k);
            if (!(f >= 0.0f)) continue;
            for (int l = 0; l < i; ++l) {
                BlockPos blockpos1;
                double d3;
                double d1;
                double d0 = this.scaleWidth * (double)f * ((double)this.rand.nextFloat() + 0.328);
                double d2 = d0 * Math.sin(d1 = (double)(this.rand.nextFloat() * 2.0f) * Math.PI) + 0.5;
                BlockPos blockpos = this.basePos.func_177963_a(d2, (double)(k - 1), d3 = d0 * Math.cos(d1) + 0.5);
                if (this.checkBlockLine(blockpos, blockpos1 = blockpos.func_177981_b(this.leafDistanceLimit)) != -1) continue;
                int i1 = this.basePos.func_177958_n() - blockpos.func_177958_n();
                int j1 = this.basePos.func_177952_p() - blockpos.func_177952_p();
                double d4 = (double)blockpos.func_177956_o() - Math.sqrt(i1 * i1 + j1 * j1) * this.branchSlope;
                int k1 = d4 > (double)j ? j : (int)d4;
                BlockPos blockpos2 = new BlockPos(this.basePos.func_177958_n(), k1, this.basePos.func_177952_p());
                if (this.checkBlockLine(blockpos2, blockpos) != -1) continue;
                this.foliageCoords.add(new FoliageCoordinates(blockpos, blockpos2.func_177956_o()));
            }
        }
    }

    void crosSection(BlockPos pos, float p_181631_2_, IBlockState p_181631_3_) {
        int i = (int)((double)p_181631_2_ + 0.618);
        for (int j = -i; j <= i; ++j) {
            for (int k = -i; k <= i; ++k) {
                BlockPos blockpos;
                IBlockState state;
                if (!(Math.pow((double)Math.abs(j) + 0.5, 2.0) + Math.pow((double)Math.abs(k) + 0.5, 2.0) <= (double)(p_181631_2_ * p_181631_2_)) || !(state = this.world.func_180495_p(blockpos = pos.func_177982_a(j, 0, k))).func_177230_c().isAir(state, (IBlockAccess)this.world, blockpos) && !state.func_177230_c().isLeaves(state, (IBlockAccess)this.world, blockpos)) continue;
                this.func_175903_a(this.world, blockpos, p_181631_3_);
            }
        }
    }

    float layerSize(int y) {
        if ((float)y < (float)this.heightLimit * 0.3f) {
            return -1.0f;
        }
        float f = (float)this.heightLimit / 2.0f;
        float f1 = f - (float)y;
        float f2 = MathHelper.func_76129_c((float)(f * f - f1 * f1));
        if (f1 == 0.0f) {
            f2 = f;
        } else if (Math.abs(f1) >= f) {
            return 0.0f;
        }
        return f2 * 0.5f;
    }

    float leafSize(int y) {
        if (y >= 0 && y < this.leafDistanceLimit) {
            return y != 0 && y != this.leafDistanceLimit - 1 ? 3.0f : 2.0f;
        }
        return -1.0f;
    }

    void generateLeafNode(BlockPos pos) {
        for (int i = 0; i < this.leafDistanceLimit; ++i) {
            this.crosSection(pos.func_177981_b(i), this.leafSize(i), LEAVES);
        }
    }

    void limb(BlockPos p_175937_1_, BlockPos p_175937_2_, Block p_175937_3_) {
        BlockPos blockpos = p_175937_2_.func_177982_a(-p_175937_1_.func_177958_n(), -p_175937_1_.func_177956_o(), -p_175937_1_.func_177952_p());
        int i = this.getGreatestDistance(blockpos);
        float f = (float)blockpos.func_177958_n() / (float)i;
        float f1 = (float)blockpos.func_177956_o() / (float)i;
        float f2 = (float)blockpos.func_177952_p() / (float)i;
        for (int j = 0; j <= i; ++j) {
            BlockPos blockpos1 = p_175937_1_.func_177963_a((double)(0.5f + (float)j * f), (double)(0.5f + (float)j * f1), (double)(0.5f + (float)j * f2));
            BlockLog.EnumAxis blocklog$enumaxis = this.getLogAxis(p_175937_1_, blockpos1);
            this.func_175903_a(this.world, blockpos1, p_175937_3_.func_176223_P().func_177226_a((IProperty)BlockLog.field_176299_a, (Comparable)blocklog$enumaxis));
        }
    }

    private int getGreatestDistance(BlockPos posIn) {
        int i = MathHelper.func_76130_a((int)posIn.func_177958_n());
        int j = MathHelper.func_76130_a((int)posIn.func_177956_o());
        int k = MathHelper.func_76130_a((int)posIn.func_177952_p());
        if (k > i && k > j) {
            return k;
        }
        return j > i ? j : i;
    }

    private BlockLog.EnumAxis getLogAxis(BlockPos p_175938_1_, BlockPos p_175938_2_) {
        int j;
        BlockLog.EnumAxis blocklog$enumaxis = BlockLog.EnumAxis.Y;
        int i = Math.abs(p_175938_2_.func_177958_n() - p_175938_1_.func_177958_n());
        int k = Math.max(i, j = Math.abs(p_175938_2_.func_177952_p() - p_175938_1_.func_177952_p()));
        if (k > 0) {
            if (i == k) {
                blocklog$enumaxis = BlockLog.EnumAxis.X;
            } else if (j == k) {
                blocklog$enumaxis = BlockLog.EnumAxis.Z;
            }
        }
        return blocklog$enumaxis;
    }

    void generateLeaves() {
        for (FoliageCoordinates worldgenbigtree$foliagecoordinates : this.foliageCoords) {
            this.generateLeafNode(worldgenbigtree$foliagecoordinates);
        }
    }

    boolean leafNodeNeedsBase(int p_76493_1_) {
        return (double)p_76493_1_ >= (double)this.heightLimit * 0.2;
    }

    public boolean generateBlock(BlockPos pos, World world, int chance) {
        if (world.func_175623_d(pos.func_177977_b())) {
            return false;
        }
        if (chance != 100) {
            int foliageZ;
            int foliageY;
            int foliageX;
            BlockPos blockPos;
            IBlockState state;
            int gen = Main.generateRandomInt(0, 100);
            if (gen <= chance && ((state = world.func_180495_p(blockPos = new BlockPos(foliageX = pos.func_177958_n(), foliageY = pos.func_177956_o(), foliageZ = pos.func_177952_p()))).func_177230_c().isAir(state, (IBlockAccess)world, blockPos) || state.func_177230_c().isLeaves(state, (IBlockAccess)world, blockPos))) {
                this.func_175903_a(world, blockPos, LOG);
                return true;
            }
        } else {
            int foliageZ;
            int foliageY;
            int foliageX = pos.func_177958_n();
            BlockPos blockPos = new BlockPos(foliageX, foliageY = pos.func_177956_o(), foliageZ = pos.func_177952_p());
            IBlockState state = world.func_180495_p(blockPos);
            if (state.func_177230_c().isAir(state, (IBlockAccess)world, blockPos) || state.func_177230_c().isLeaves(state, (IBlockAccess)world, blockPos)) {
                this.func_175903_a(world, blockPos, LOG);
                return true;
            }
        }
        return false;
    }

    void generateTrunk() {
        BlockPos blockpos = this.basePos;
        int ab = 0;
        int cd = 70;
        do {
            this.generateBlock(blockpos.func_177968_d().func_177981_b(ab), this.world, cd);
            this.generateBlock(blockpos.func_177976_e().func_177981_b(ab), this.world, cd);
            this.generateBlock(blockpos.func_177978_c().func_177981_b(ab), this.world, cd);
            this.generateBlock(blockpos.func_177974_f().func_177981_b(ab), this.world, cd);
            ++ab;
        } while ((cd -= 30) != 10);
        BlockPos blockpos1 = this.basePos.func_177981_b(this.height);
        Block block = LOG.func_177230_c();
        this.limb(blockpos, blockpos1, block);
        if (this.trunkSize == 2) {
            this.limb(blockpos.func_177974_f(), blockpos1.func_177974_f(), block);
            this.limb(blockpos.func_177974_f().func_177968_d(), blockpos1.func_177974_f().func_177968_d(), block);
            this.limb(blockpos.func_177968_d(), blockpos1.func_177968_d(), block);
        }
    }

    void generateLeafNodeBases() {
        for (FoliageCoordinates worldgenbigtree$foliagecoordinates : this.foliageCoords) {
            int i = worldgenbigtree$foliagecoordinates.getBranchBase();
            BlockPos blockpos = new BlockPos(this.basePos.func_177958_n(), i, this.basePos.func_177952_p());
            if (blockpos.equals((Object)worldgenbigtree$foliagecoordinates) || !this.leafNodeNeedsBase(i - this.basePos.func_177956_o())) continue;
            this.limb(blockpos, worldgenbigtree$foliagecoordinates, LOG.func_177230_c());
        }
    }

    int checkBlockLine(BlockPos posOne, BlockPos posTwo) {
        BlockPos blockpos = posTwo.func_177982_a(-posOne.func_177958_n(), -posOne.func_177956_o(), -posOne.func_177952_p());
        int i = this.getGreatestDistance(blockpos);
        float f = (float)blockpos.func_177958_n() / (float)i;
        float f1 = (float)blockpos.func_177956_o() / (float)i;
        float f2 = (float)blockpos.func_177952_p() / (float)i;
        if (i == 0) {
            return -1;
        }
        for (int j = 0; j <= i; ++j) {
            BlockPos blockpos1 = posOne.func_177963_a((double)(0.5f + (float)j * f), (double)(0.5f + (float)j * f1), (double)(0.5f + (float)j * f2));
            if (this.isReplaceable(this.world, blockpos1)) continue;
            return j;
        }
        return -1;
    }

    public void func_175904_e() {
        this.leafDistanceLimit = 5;
    }

    public boolean func_180709_b(World worldIn, Random rand, BlockPos position) {
        this.world = worldIn;
        this.basePos = position;
        this.rand = new Random(rand.nextLong());
        if (this.heightLimit == 0) {
            this.heightLimit = 5 + this.rand.nextInt(this.heightLimitLimit);
        }
        if (!this.validTreeLocation()) {
            this.world = null;
            return false;
        }
        this.generateLeafNodeList();
        this.generateLeaves();
        this.generateTrunk();
        this.generateLeafNodeBases();
        this.world = null;
        return true;
    }

    private boolean validTreeLocation() {
        BlockPos down = this.basePos.func_177977_b();
        IBlockState state = this.world.func_180495_p(down);
        boolean isSoil = state.func_177230_c().canSustainPlant(state, (IBlockAccess)this.world, down, EnumFacing.UP, (IPlantable)((BlockBush)ModBlocks.EUCALYPTUS_SAPLING));
        if (!isSoil) {
            return false;
        }
        int i = this.checkBlockLine(this.basePos, this.basePos.func_177981_b(this.heightLimit - 1));
        if (i == -1) {
            return true;
        }
        if (i < 6) {
            return false;
        }
        this.heightLimit = i;
        return true;
    }

    static class FoliageCoordinates
    extends BlockPos {
        private final int branchBase;

        public FoliageCoordinates(BlockPos pos, int p_i45635_2_) {
            super(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            this.branchBase = p_i45635_2_;
        }

        public int getBranchBase() {
            return this.branchBase;
        }
    }
}

